/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.portal.cms.security;

import org.jboss.portal.identity.User;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * An implementation of SecurityContext for the core Portal Engine
 *
 * @author Sohil Shah - sohil.shah@jboss.com - Nov 27, 2006
 */
public class PortalCMSSecurityContext implements Serializable
{
   private Map contextMap = null;

   /** signifies the user currently logged in to the system */
   private User portalUser = null;


   /**
    *
    *
    */
   public PortalCMSSecurityContext(User portalUser)
   {
      super();
      this.portalUser = portalUser;
      this.contextMap = new HashMap();
   }

   /**
    * This method returns the Identity of the user logged into the portal. The return value is of type
    * org.jboss.portal.identity.User
    *
    * @return Identity related information associated with the user logged into the portal
    */
   public Object getIdentity()
   {
      return this.portalUser;
   }

   /**
    * Returns value corresponding to the specified attribute name
    *
    * @param name
    * @return
    */
   public Object getAttribute(String name)
   {
      return this.contextMap.get(name);
   }

   /**
    * Sets a specified value corresponding to the specified name in the context
    *
    * @param name
    * @param value
    */
   public void setAttribute(String name, Object value)
   {
      this.contextMap.put(name, value);
   }

   /**
    * Removes the specified attribute
    *
    * @param name
    */
   public void removeAttribute(String name)
   {
      this.contextMap.remove(name);
   }

   /**
    * Returns an array of Strings consisting of all keys/names stored in the context
    *
    * @return
    */
   public String[] getAttributeNames()
   {
      return (String[])this.contextMap.keySet().toArray();
   }
}
