/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.portal.cms.security;

import java.security.BasicPermission;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/** @author Sohil Shah - sohil.shah@jboss.com - Nov 28, 2006 */
public class Permission extends BasicPermission
{
   /**
    *
    */
   private long id = 0; //unique id for this permission object in the storage (typically database)
   private String service = null; //portal service that this permission applies to like cms etc
   private String action = null; //action on the service that needs to be protected
   private boolean isNegated = false;

   /**
    *
    */
   private Set criteria = null;
   private Set roleAssoc = null;
   private Set userAssoc = null;

   /**
    *
    */
   private Set roles = null; //these are information carrying fields, they are not persisted in the database
   private Set users = null; //these are information carrying fields, they are not persisted in the database

   /**
    *
    *
    */
   public Permission()
   {
      this("null");
   }


   /** @param name  */
   public Permission(String service)
   {
      super(service);
      this.service = service;
   }

   /**
    * @param name
    * @param actions
    */
   public Permission(String service, String actions)
   {
      super(service, actions);
      this.service = service;
      this.action = actions;
   }


   /** @return  */
   public long getId()
   {
      return this.id;
   }

   /** @param id  */
   public void setId(long id)
   {
      this.id = id;
   }

   /** @return  */
   public Set getCriteria()
   {
      return this.criteria;
   }

   /** @param criteria  */
   public void setCriteria(Set criteria)
   {
      this.criteria = criteria;
   }

   /** @param criteria  */
   public void addCriteria(Criteria criteria)
   {
      if (this.criteria == null)
      {
         this.criteria = new HashSet();
      }
      this.criteria.add(criteria);
   }

   /** @return  */
   public String getService()
   {
      return this.service;
   }


   /** @param name  */
   public void setService(String service)
   {
      this.service = service;
   }

   /** @return  */
   public String getAction()
   {
      return this.action;
   }

   /** @param action  */
   public void setAction(String action)
   {
      this.action = action;
   }


   /**
    * Finds the specified criteria value for the criteriaId
    *
    * @param criteriaId
    * @return value of the criteria
    */
   public String findCriteriaValue(String criteriaId)
   {
      String value = null;
      if (this.criteria != null)
      {
         for (Iterator itr = this.criteria.iterator(); itr.hasNext();)
         {
            Criteria cour = (Criteria)itr.next();
            if (criteriaId.equals(cour.getName()))
            {
               value = cour.getValue();
            }
         }
      }
      return value;
   }

   /** @return  */
   public boolean isNegated()
   {
      return isNegated;
   }

   /** @param isNegated  */
   public void setNegated(boolean isNegated)
   {
      this.isNegated = isNegated;
   }

   /** @return  */
   public Set getRoleAssoc()
   {
      return roleAssoc;
   }

   /** @param roleAssoc  */
   public void setRoleAssoc(Set roleAssoc)
   {
      this.roleAssoc = roleAssoc;
   }

   /** @param roleAssoc  */
   public void addRoleAssoc(PermRoleAssoc roleAssoc)
   {
      if (this.roleAssoc == null)
      {
         this.roleAssoc = new HashSet();
      }
      this.roleAssoc.add(roleAssoc);
   }

   /** @return  */
   public Set getRoleAssocIds()
   {
      Set ids = new HashSet();
      if (this.roleAssoc != null)
      {
         for (Iterator itr = this.roleAssoc.iterator(); itr.hasNext();)
         {
            PermRoleAssoc cour = (PermRoleAssoc)itr.next();
            ids.add(cour.getRoleId());
         }
      }
      return ids;
   }

   /** @return  */
   public Set getUserAssoc()
   {
      return userAssoc;
   }

   /** @param userAssoc  */
   public void setUserAssoc(Set userAssoc)
   {
      this.userAssoc = userAssoc;
   }

   /** @param userAssoc  */
   public void addUserAssoc(PermUserAssoc userAssoc)
   {
      if (this.userAssoc == null)
      {
         this.userAssoc = new HashSet();
      }
      this.userAssoc.add(userAssoc);
   }

   /** @return  */
   public Set getUserAssocIds()
   {
      Set ids = new HashSet();
      if (this.userAssoc != null)
      {
         for (Iterator itr = this.userAssoc.iterator(); itr.hasNext();)
         {
            PermUserAssoc cour = (PermUserAssoc)itr.next();
            ids.add(cour.getUserId());
         }
      }
      return ids;
   }

   /** @return  */
   public Set getRoles()
   {
      return roles;
   }

   /** @param roles  */
   public void setRoles(Set roles)
   {
      this.roles = roles;
   }

   /** @return  */
   public Set getUsers()
   {
      return users;
   }

   /** @param users  */
   public void setUsers(Set users)
   {
      this.users = users;
   }


   /**
    *
    */
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();

      buffer.append("-----------------------------\n");
      buffer.append("ID=" + this.id + "\n");
      buffer.append("Service=" + this.service + "\n");
      buffer.append("Action=" + this.action + "\n");
      buffer.append("Negated=" + this.isNegated + "\n");

      //print role association
      if (this.roleAssoc != null)
      {
         for (Iterator itr = this.roleAssoc.iterator(); itr.hasNext();)
         {
            PermRoleAssoc cour = (PermRoleAssoc)itr.next();
            buffer.append("Role =" + cour.getRoleId() + "\n");
         }
      }

      //print user association
      if (this.userAssoc != null)
      {
         for (Iterator itr = this.userAssoc.iterator(); itr.hasNext();)
         {
            PermUserAssoc cour = (PermUserAssoc)itr.next();
            buffer.append("User =" + cour.getUserId() + "\n");
         }
      }

      //print criteria
      if (this.criteria != null)
      {
         for (Iterator itr = this.criteria.iterator(); itr.hasNext();)
         {
            Criteria cour = (Criteria)itr.next();
            buffer.append("Criteria =" + cour.getName() + "," + cour.getValue() + "\n");
         }
      }

      buffer.append("-----------------------------\n");

      return buffer.toString();
   }


   /**
    *
    */
   public boolean equals(Object obj)
   {
      boolean equals = false;
      if (obj instanceof Permission)
      {
         Permission input = (Permission)obj;
         if (input.id == this.id)
         {
            equals = true;
         }
      }
      return equals;
   }
}
