/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.security;


import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.spi.provider.PermissionRepository;

import javax.security.auth.Subject;

/**
 * Created on : Jan 23, 2007
 *
 * @author Sohil Shah - sohil.shah@jboss.com
 */
public class CMSPermission extends PortalPermission
{
   private PortalCMSSecurityContext securityContext = null;

   /**
    *
    */
   public CMSPermission(String name, String uri)
   {
      super(name, uri);
   }

   /** @param wrappedPermission  */
   public CMSPermission(PortalCMSSecurityContext securityContext)
   {
      super("", "");
      this.securityContext = securityContext;
   }

   //--------PortalPermission implementation------------------------------------------------------------
   /**
    *
    */
   public String getType()
   {
      return this.getClass().getName();
   }

   /**
    *
    */
   public boolean implies(PermissionRepository repository, Subject caller,
                          String roleName, PortalPermission permission)
      throws PortalSecurityException
   {
      return false;
   }

   /** @return  */
   public PortalCMSSecurityContext getSecurityContext()
   {
      return this.securityContext;
   }

   //-------Permission implementation------------------------------------------------------------------
   /**
    *
    */
   public boolean equals(Object obj)
   {
      return false;
   }

   /**
    *
    */
   public String getActions()
   {
      return null;
   }

   /**
    *
    */
   public int hashCode()
   {
      return 0;
   }

   /**
    *
    */
   public boolean implies(java.security.Permission permission)
   {
      return false;
   }
}
