/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.security;

import org.jboss.portal.cms.impl.jcr.command.ACLEnforcer;
import org.jboss.portal.jems.as.JNDI;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;

import javax.security.auth.Subject;

/**
 * Created on : Jan 23, 2007
 *
 * @author Sohil Shah - sohil.shah@jboss.com
 */
public class AuthorizationManagerImpl extends AbstractJBossService implements AuthorizationManager
{
   /**
    *
    */
   private ACLEnforcer enforcer = null;

   /**
    *
    */
   private AuthorizationProvider provider = null;

   /**
    *
    */
   private String jndiName = null;
   private JNDI.Binding jndiBinding = null;

   /** @return  */
   public AuthorizationProvider getProvider()
   {
      return provider;
   }

   /** @param provider  */
   public void setProvider(AuthorizationProvider provider)
   {
      this.provider = provider;
   }

   /** @return  */
   public String getJNDIName()
   {
      return this.jndiName;
   }

   /** @param jndiName  */
   public void setJNDIName(String jndiName)
   {
      this.jndiName = jndiName;
   }

   /**
    *
    */
   public void startService() throws Exception
   {
      super.startService();

      //perform jndi registration for this service
      if (this.jndiName != null)
      {
         jndiBinding = new JNDI.Binding(jndiName, this);
         jndiBinding.bind();
      }

      //initialize the authorization/policy enforcer
      setEnforcer(new ACLEnforcer(this));
   }

   //---PortalAuthorizationManagerFactory implementation-----------------------------------------------
   /**
    *
    */
   public PortalAuthorizationManager getManager() throws PortalSecurityException
   {
      return this;
   }

   //---PortalAuthorizationManager implementation-------------------------------------------------------
   /**
    *
    */
   public boolean checkPermission(PortalPermission permission) throws PortalSecurityException
   {
      return this.enforcer.hasAccess(((CMSPermission)permission).getSecurityContext());
   }

   /**
    *
    */
   public boolean checkPermission(Subject checkedSubject, PortalPermission permission) throws PortalSecurityException
   {
      return this.checkPermission(permission);
   }
   
   protected void setEnforcer(ACLEnforcer enforcer)
   {
      this.enforcer = enforcer;
   }
}
