/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.search;

import org.jboss.portal.cms.CMS;
import org.jboss.portal.cms.Command;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.search.Query;
import org.jboss.portal.search.QueryConverter;
import org.jboss.portal.search.impl.AbstractFederatedSearcher;
import org.jboss.portal.search.impl.jcr.JCRQuery;
import org.jboss.portal.search.impl.jcr.JCRQueryConverter;
import org.jboss.portal.search.result.ResultSet;

import java.util.Iterator;
import java.util.List;

/**
 * @author <a href="mailto:theute@jboss.org">Thomas Heute</a>
 * @version $Revision$
 */
public class CMSFederatedSearch extends AbstractFederatedSearcher
{
   private CMS cms;
   private String urlPrefix;
   private JCRQueryConverter queryConverter;

   public CMSFederatedSearch(String id)
   {
      setId(id);
      setDisplayName(new LocalizedString("Content Management System"));
      this.urlPrefix = "portal/content";
      this.queryConverter = new JCRQueryConverter();
   }

   public void setCMS(CMS cms)
   {
      this.cms = cms;
   }

   public ResultSet search(Query query)
   {
      Command searchCommand = cms.getCommandFactory().createSearchCommand((JCRQuery)query);
      List files = (List)cms.execute(searchCommand);
      ResultSet results = new ResultSet(this);

      Iterator it = files.iterator();
      while (it.hasNext())
      {
         File file = (File)it.next();
         results.add(new CMSResult(file, urlPrefix));
      }
      return results;
   }

   public QueryConverter getQueryConverter()
   {
      return queryConverter;
   }

}
