/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.management;

import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.Command;
import org.jboss.portal.cms.model.Folder;
import org.jboss.portal.jems.as.system.AbstractJBossService;

import java.util.List;

/**
 * Unused. With the introduction of CMS security, this can no longer count CMS files.
 *
 * @author <a href="mailto:theute@jboss.org">Thomas Heute</a>
 * @version $Revision$
 */
public class CMSImpl extends AbstractJBossService implements CMS
{

   private org.jboss.portal.cms.CMS cms;

   public void setCMS(org.jboss.portal.cms.CMS cms)
   {
      this.cms = cms;
   }

   /** Very costly TODO: Make it cheap */
   public int getNbFiles()
   {
      String sPath = "/";
      try
      {
         return nbFiles(sPath);
      }
      catch (CMSException e)
      {
         e.printStackTrace();
      }
      return -1;
   }

   private int nbFiles(String path) throws CMSException
   {
      Command listCMD = cms.getCommandFactory().createFolderGetListCommand(path);
      Folder mainFolder = (Folder)cms.execute(listCMD);
      List files = mainFolder.getFiles();
      int nbFiles = files.size();
      List folders = mainFolder.getFolders();
      for (int i = 0; i < folders.size(); i++)
      {
         Folder folder = (Folder)folders.get(i);
         nbFiles += nbFiles(folder.getBasePath());
      }
      return nbFiles;
   }

}
