/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.composite;

import org.jboss.portal.cms.impl.jcr.JCRCompositeCommand;
import org.jboss.portal.cms.impl.jcr.command.ContentCreateNewVersionCommand;
import org.jboss.portal.cms.impl.jcr.command.FileUpdateCommand;
import org.jboss.portal.cms.model.Content;
import org.jboss.portal.cms.model.File;

import java.util.Locale;

/** @author <a href="mailto:theute@jboss.org">Thomas Heute</a> */
public class UpdateFileCommand extends JCRCompositeCommand
{

   /** The serialVersionUID */
   private static final long serialVersionUID = -2790754339976591532L;

   /** . */
   private String path;
   private Content content;

   /** . */
   private Locale locale;

   public String getPath()
   {
      return path;
   }

   /** @return  */
   public Content getContent()
   {
      return this.content;
   }

   public Locale getLocale()
   {
      return locale;
   }

   public UpdateFileCommand(File file, Content content, boolean makeLive)
   {
      path = file.getBasePath();
      locale = content.getLocale();
      this.content = content;

      //
      FileUpdateCommand fileUpdateCMD = new FileUpdateCommand(file);
      ContentCreateNewVersionCommand verCMD = new ContentCreateNewVersionCommand(content, makeLive);

      //
      commands.add(fileUpdateCMD);
      commands.add(verCMD);
   }

}