/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.command;

import org.apache.log4j.Logger;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.jcr.JCRCommand;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.version.VersionHistory;


/**
 * Makes the specified version of the file a "LIVE" version
 *
 * @author <a href="mailto:sohil.shah@jboss.com">Sohil Shah</a>
 */
public class MakeLiveVersionCommand extends JCRCommand
{
   /**
    *
    */
   private static Logger log = Logger.getLogger(MakeLiveVersionCommand.class);

   /** The serialVersionUID */
   private static final long serialVersionUID = 6853173755818339647L;
   String msFilePath = null;
   String language = null;
   String version = null;

   /**
    * @param sFilePath
    * @param language
    * @param version
    */
   public MakeLiveVersionCommand(String sFilePath, String language, String version)
   {
      this.msFilePath = sFilePath;
      this.version = version;
      this.language = language;
   }

   /**
    *
    */
   public Object execute()
   {
      String versionMadeLive = null;
      try
      {
         Session session = context.getSession();
         Node fileNode = (Node)session.getItem(this.msFilePath + "/" + this.language);

         VersionHistory vh = fileNode.getVersionHistory();
         vh.addVersionLabel(this.version, "LIVE", true);
         versionMadeLive = this.version;
      }
      catch (Exception e)
      {
         log.error(this, e);
         throw new CMSException(e);
      }
      return versionMadeLive;
   }
}
