/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.command;

import org.jboss.portal.cms.impl.FolderImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.model.Folder;

import javax.jcr.Node;

/**
 * Returns a folder obj for a given path.
 *
 * @author <a href="mailto:roy@jboss.org">Roy Russo</a>
 */
public class FolderGetCommand extends JCRCommand
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 1770873951262277315L;
   String msPath;

   public FolderGetCommand(String sPath)
   {
      this.msPath = sPath;
   }

   public Object execute()
   {
      try
      {
         Folder folder = new FolderImpl();

         Node folderNode = (Node)context.getSession().getItem(msPath);
         folder.setName(folderNode.getName());
         folder.setDescription(folderNode.getProperty("portalcms:description").getString());
         folder.setLastModified(folderNode.getProperty("portalcms:lastmodified").getDate().getTime());
         folder.setBasePath(msPath);
         folder.setCreationDate(folderNode.getProperty("jcr:created").getDate().getTime());
         return folder;
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      return null;
   }
}
