/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.command;

import org.jboss.portal.cms.impl.ContentImpl;
import org.jboss.portal.cms.impl.FileImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.model.Content;
import org.jboss.portal.cms.model.File;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.nodetype.NodeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * Returns a list of content nodes under a filenode, but ignores versioning labels.
 *
 * @author <a href="mailto:roy@jboss.org">Roy Russo</a>
 */
public class FileGetListCommand extends JCRCommand
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 7601421931789710938L;
   String sFilePath;

   public FileGetListCommand(String sFilePath)
   {
      this.sFilePath = sFilePath;
   }

   public Object execute()
   {
      List contents = new ArrayList();
      try
      {
         File file = new FileImpl();

         Node fileNode = (Node)context.getSession().getItem(sFilePath);
         file.setName(fileNode.getName());
         file.setBasePath(sFilePath);

         // get child content objects
         NodeIterator ni = fileNode.getNodes();
         while (ni.hasNext())
         {
            Node contentNode = ni.nextNode();
            NodeType nt = contentNode.getPrimaryNodeType();
            if (nt.getName().equals("portalcms:content"))
            {
               Content content = new ContentImpl();
               content.setCreationDate(contentNode.getProperty("jcr:created").getDate().getTime());
               content.setLastModified(contentNode.getProperty("jcr:lastModified").getDate().getTime());
               content.setBasePath(contentNode.getPath());
               content.setDescription(contentNode.getProperty("portalcms:description").getString());
               content.setTitle(contentNode.getProperty("portalcms:title").getString());
               content.setMimeType(contentNode.getProperty("jcr:mimeType").getString());
               content.setName(contentNode.getName());
               content.setEncoding(contentNode.getProperty("jcr:encoding").getString());
               content.setStream(contentNode.getProperty("jcr:data").getStream());
               content.setLocale(new Locale(contentNode.getProperty("portalcms:language").getString()));
               if (contentNode.hasProperty("portalcms:size"))
               {
                  long size = Long.parseLong(contentNode.getProperty("portalcms:size").getString());
                  content.setSize(size);
               }
               contents.add(content);
            }
         }
         return contents;
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      return null;
   }
}
