/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.command;

import org.jboss.portal.cms.impl.jcr.JCRCommand;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Session;

/** @author <a href="mailto:roy@jboss.org">Roy Russo</a> */
public class DeleteCommand extends JCRCommand
{
   /** The serialVersionUID */
   private static final long serialVersionUID = -3714090346539111871L;
   String msPath;

   public String getPath()
   {
      return msPath;
   }

   public DeleteCommand(String sPath)
   {
      this.msPath = sPath;
   }

   public Object execute()
   {
      try
      {
         Session session = context.getSession();
         if (session.itemExists(msPath))
         {
            Item item = session.getItem(msPath);
            Node parentNode = item.getParent();
            item.remove();
            parentNode.save();
         }
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      return null;
   }
}
