/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr.command;

import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.util.VersionUtil;
import org.jboss.portal.cms.util.NodeUtil;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Workspace;

/**
 * @author <a href="mailto:roy@jboss.org">Roy Russo</a>
 * @author <a href="mailto:theute@jboss.org">Thoams Heute</a>
 */
public class CopyCommand extends JCRCommand
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 3968683882225629932L;
   String msFromPath;
   String msToPath;

   public CopyCommand(String sFromPath, String sToPath)
   {
      validatePath(sFromPath);
      validatePath(sToPath);
      this.msFromPath = sFromPath;
      this.msToPath = sToPath;
   }

   public Object execute()
   {
      try
      {
         Workspace wsp = context.getSession().getWorkspace();
         wsp.copy(msFromPath, msToPath);

         Item item = wsp.getSession().getItem(msToPath);
         Node node = (Node)item;

         // Versions the result and make it "live"
         VersionUtil.createVersion(node, true);

         // Useless per the spec.
         // context.getSession().save();
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      return null;
   }
}
