/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr;

import org.jboss.portal.cms.CMSException;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/** @author <a href="mailto:theute@jboss.org">Thomas Heute</a> */
public abstract class JCRCompositeCommand extends JCRCommand
{
   protected List commands;

   public JCRCompositeCommand()
   {
      commands = new ArrayList();
   }

   public Object execute() throws CMSException
   {
      Iterator iterator = commands.iterator();
      Object returnObject = null;
      while (iterator.hasNext())
      {
         JCRCommand command = (JCRCommand)iterator.next();
         command.setContext(context);
         returnObject = command.execute();
      }
      return returnObject;
   }
}
