/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr;

import org.jboss.portal.cms.Command;
import org.jboss.portal.cms.CommandFactory;
import org.jboss.portal.cms.impl.jcr.command.ContentCreateCommand;
import org.jboss.portal.cms.impl.jcr.command.ContentCreateNewVersionCommand;
import org.jboss.portal.cms.impl.jcr.command.ContentGetCommand;
import org.jboss.portal.cms.impl.jcr.command.ContentGetVersionsCommand;
import org.jboss.portal.cms.impl.jcr.command.CopyCommand;
import org.jboss.portal.cms.impl.jcr.command.DeleteCommand;
import org.jboss.portal.cms.impl.jcr.command.FileCreateCommand;
import org.jboss.portal.cms.impl.jcr.command.FileGetCommand;
import org.jboss.portal.cms.impl.jcr.command.FileGetListCommand;
import org.jboss.portal.cms.impl.jcr.command.FileUpdateCommand;
import org.jboss.portal.cms.impl.jcr.command.FolderCreateCommand;
import org.jboss.portal.cms.impl.jcr.command.FolderGetCommand;
import org.jboss.portal.cms.impl.jcr.command.FolderGetListCommand;
import org.jboss.portal.cms.impl.jcr.command.FolderUpdateCommand;
import org.jboss.portal.cms.impl.jcr.command.GetArchiveCommand;
import org.jboss.portal.cms.impl.jcr.command.ItemExistsCommand;
import org.jboss.portal.cms.impl.jcr.command.MakeLiveVersionCommand;
import org.jboss.portal.cms.impl.jcr.command.MoveCommand;
import org.jboss.portal.cms.impl.jcr.command.RenameCommand;
import org.jboss.portal.cms.impl.jcr.command.SearchCommand;
import org.jboss.portal.cms.impl.jcr.command.StoreArchiveCommand;
import org.jboss.portal.cms.impl.jcr.command.DownloadArchiveCommand;
import org.jboss.portal.cms.impl.jcr.composite.NewFileCommand;
import org.jboss.portal.cms.impl.jcr.composite.UpdateFileCommand;
import org.jboss.portal.cms.model.Content;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.cms.model.Folder;
import org.jboss.portal.search.impl.jcr.JCRQuery;

import org.jboss.portal.cms.impl.jcr.command.AsyncStoreArchiveCommand;

import java.util.List;
import java.util.Locale;

/**
 * @author <a href="mailto:roy@jboss.org">Roy Russo</a>
 * @author <a href="mailto:theute@jboss.org">Thomas Heute</a>
 */
public class JCRCommandFactory implements CommandFactory
{
   public JCRCommandFactory()
   {
   }

   public Command createNewFileCommand(File sFile, Content content)
   {
      return new NewFileCommand(sFile, content);
   }

   public Command createUpdateFileCommand(File sFile, Content content, boolean makeLive)
   {
      return new UpdateFileCommand(sFile, content, makeLive);
   }

   public Command createCopyCommand(String sFromPath, String sToPath)
   {
      return new CopyCommand(sFromPath, sToPath);
   }

   public Command createMoveCommand(String sFromPath, String sToPath)
   {
      return new MoveCommand(sFromPath, sToPath);
   }

   public Command createRenameCommand(String sPath, String sNewName)
   {
      return new RenameCommand(sPath, sNewName);
   }

   public Command createDeleteCommand(String sPath)
   {
      return new DeleteCommand(sPath);
   }

   public Command createFileSaveCommand(File file)
   {
      return new FileCreateCommand(file);
   }

   public Command createFileGetCommand(String sFilePath, String sVersionNumber, Locale locale)
   {
      return new FileGetCommand(sFilePath, sVersionNumber, locale);
   }

   public Command createFileGetCommand(String sFilePath, Locale locale)
   {
      return new FileGetCommand(sFilePath, locale);
   }

   public Command createFileUpdateCommand(File file)
   {
      return new FileUpdateCommand(file);
   }

   public Command createFolderSaveCommand(Folder folder)
   {
      return new FolderCreateCommand(folder);
   }

   public Command createFolderGetCommand(String sFolderPath)
   {
      return new FolderGetCommand(sFolderPath);
   }

   public Command createFolderUpdateCommand(Folder folder)
   {
      return new FolderUpdateCommand(folder);
   }

   public Command createContentGetVersionsCommand(String sFilePath)
   {
      return new ContentGetVersionsCommand(sFilePath);
   }

   public Command createFolderGetListCommand(String sFolderPath)
   {
      return new FolderGetListCommand(sFolderPath);
   }

   public Command createContentCreateNewVersionCommand(Content content, boolean bMakeLive)
   {
      return new ContentCreateNewVersionCommand(content, bMakeLive);
   }

   public Command createContentCreateNewVersionCommand(List contents, boolean bMakeLive)
   {
      return new ContentCreateNewVersionCommand(contents, bMakeLive);
   }

   public Command createStoreArchiveCommand(String sRootPath, byte[] archiveBytes, String sLanguage)
   {
      return new StoreArchiveCommand(sRootPath, archiveBytes, sLanguage);      
   }
   
   public Command createAsyncStoreArchiveCommand(String sRootPath, byte[] archiveBytes, String sLanguage)
   {      
      return new AsyncStoreArchiveCommand(sRootPath, archiveBytes, sLanguage);
   }

   public Command createItemExistsCommand(String sPath)
   {
      return new ItemExistsCommand(sPath);
   }

   public Command createContentSaveCommand(File file)
   {
      return new ContentCreateCommand(file);
   }

   public Command createContentGetCommand(String sPath, String sVersionNumber, Locale locale)
   {
      return new ContentGetCommand(sPath, sVersionNumber, locale);
   }

   public Command createFileGetListCommand(String sFilePath)
   {
      return new FileGetListCommand(sFilePath);
   }

   public Command createGetArchiveCommand(String sRootPath, String sLanguage)
   {
      return new GetArchiveCommand(sRootPath, sLanguage);
   }

   public Command createSearchCommand(JCRQuery query)
   {
      return new SearchCommand(query);
   }

   public Command createMakeLiveVersionCommand(String filePath, String language, String version)
   {
      return new MakeLiveVersionCommand(filePath, language, version);
   }   

   public Command createDownloadArchiveCommand(String filePath)
   {
      return new DownloadArchiveCommand(filePath);
   }   
}
