/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr;

import org.jboss.portal.cms.CMSException;
import org.jboss.portal.common.invocation.AbstractInvocationContext;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.common.invocation.resolver.MapAttributeResolver;

import javax.jcr.Session;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 7163 $
 */
public class JCRCommandContext extends AbstractInvocationContext implements Serializable
{
   public static final Scope scope = Scope.THREAD_SCOPE;

   private transient final Session session;

   private transient final JCRCommandFactory commandFactory;

   private transient final Locale locale;

   private Map clusterContext = null;

   public JCRCommandContext(Session session, JCRCommandFactory factory, Locale locale)
   {
      this.session = session;
      this.commandFactory = factory;
      this.locale = locale;
      this.addResolver(JCRCommandContext.scope, new MapAttributeResolver());
   }

   public JCRCommandFactory getCommandFactory()
   {
      return commandFactory;
   }

   public Session getSession()
   {
      return session;
   }

   public Object execute(JCRCommand cmd) throws CMSException
   {
      cmd.setContext(this);
      return cmd.execute();
   }

   public Locale getDefaultLocale()
   {
      return locale;
   }

   /**
    * @param key
    * @param data
    */
   public void setClusterContextInfo(String key, Object data)
   {
      this.getClusterContext().put(key, data);
   }

   /**
    * @param key
    * @return
    */
   public Object getClusterContextInfo(String key)
   {
      return this.getClusterContext().get(key);
   }

   /**
    * Instantiates the cluser context only on-demand
    *
    * @return
    */
   private Map getClusterContext()
   {
      if (this.clusterContext == null)
      {
         this.clusterContext = new HashMap();
      }
      return this.clusterContext;
   }
}
