/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.jcr;

import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.Command;
import org.jboss.portal.cms.util.NodeUtil;
import org.jboss.portal.common.invocation.InvocationContext;

import java.io.Serializable;


/**
 * Interface for executing operations.
 *
 * @author <a href="mailto:roy@jboss.org">Roy Russo</a>
 * @author <a href="mailto:theute@jboss.org">Thomas Heute</a>
 */
public abstract class JCRCommand extends Command implements Serializable
{
   public static String JCR_SESSION_ATTRIBUTE = "org.jboss.portal.cms.jcr.session";
   public static String JCR_COMMANDFATORY_ATTRIBUTE = "org.jboss.portal.cms.jcr.commandfactory";
   public static String JCR_LOCALE_ATTRIBUTE = "org.jboss.portal.cms.jcr.locale";

   protected JCRCommandContext context;

   public InvocationContext getContext()
   {
      return context;
   }

   public void setContext(JCRCommandContext context)
   {
      this.context = context;
   }

   public abstract Object execute() throws CMSException;

   protected void validatePath(String path)
   {
      boolean isValid = NodeUtil.isValidPath(path);
      if (!isValid)
      {
         throw new CMSException("Path: " + path + " is not a legal path element.");
      }
   }
}
