/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl.interceptors;

import org.jboss.portal.cms.CMSInterceptor;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;
import org.jboss.portal.cms.impl.jcr.composite.NewFileCommand;
import org.jboss.portal.cms.impl.jcr.composite.UpdateFileCommand;
import org.jboss.portal.cms.workflow.ApprovePublish;
import org.jboss.portal.cms.workflow.Content;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.identity.User;
import org.jboss.portal.jems.as.JNDI;

import java.lang.reflect.Method;
import java.util.Date;


/**
 * Created on : Jan 29, 2007
 *
 * @author Sohil Shah - sohil.shah@jboss.com
 */
public class ApprovalWorkflowInterceptor extends CMSInterceptor
{
   /**
    *
    */
   private String jndiName = null;

   /**
    *
    */
   private JNDI.Binding jndiBinding = null;

   /** @return  */
   public String getJNDIName()
   {
      return this.jndiName;
   }

   /** @param jndiName  */
   public void setJNDIName(String jndiName)
   {
      this.jndiName = jndiName;
   }

   /**
    *
    */
   protected Object invoke(JCRCommand invocation) throws Exception, InvocationException
   {
      //pre-processing
      if (invocation instanceof NewFileCommand || invocation instanceof UpdateFileCommand)
      {
         ApprovePublish approvePublishWorkflow = (ApprovePublish)invocation.getContext().
            getAttribute(JCRCommandContext.scope, "approvePublishWorkflow");

         if (approvePublishWorkflow != null)
         {
            User user = (User)invocation.getContext().getAttribute(JCRCommandContext.scope, "user");
            org.jboss.portal.cms.model.Content content = null;
            Method getContentMethod = invocation.getClass().getMethod("getContent", null);
            content = (org.jboss.portal.cms.model.Content)getContentMethod.invoke(invocation, null);

            //call the workflow service here
            Content workflowContent = new Content();
            workflowContent.setPath(content.getBasePath());
            workflowContent.setUserName(user.getUserName());
            workflowContent.setMimeType(content.getMimeType());
            if (content.getBytes() != null)
            {
               workflowContent.setSize(content.getBytes().length);
            }
            workflowContent.setCreationDate(new Date());

            long processId = approvePublishWorkflow.requestApproval(workflowContent);

            //save the processId in the context
            invocation.setAttribute(JCRCommandContext.scope, "processid", String.valueOf(processId));
         }
      }

      Object returnVal = invocation.invokeNext();

      //post-processing

      //no post-processing needed for this interceptor

      return returnVal;
   }

   /** @throws Exception  */
   public void start() throws Exception
   {
      if (this.jndiName != null)
      {
         this.jndiBinding = new JNDI.Binding(jndiName, this);
         this.jndiBinding.bind();
      }
   }

   /** @throws Exception  */
   public void stop() throws Exception
   {
      if (this.jndiBinding != null)
      {
         this.jndiBinding.unbind();
         this.jndiBinding = null;
      }
   }
}
