/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl;

import org.jboss.portal.cms.model.File;

import java.util.Locale;

/**
 * @author <a href="mailto:theute@jboss.org">Thomas Heute</a>
 * @version $Revision: 5448 $
 */
public interface CMSTreeCacheService
{

   public static String JNDIName = "java:/portal/cms/CMSTreeCache";

   /** Get a file from the cache, returns null if the file cannot be found */
   public File get(String path, Locale locale);

   /** Put a CMS file into the cache */
   public void put(String path, Locale locale, File file);

   /**
    * Remove a localized file
    *
    * @throws CacheException
    */
   public void remove(String path, Locale locale) throws CMSCacheException;

   /**
    * Remove a file (all languages)
    *
    * @throws CacheException
    */
   public void remove(String path) throws CMSCacheException;

}
