/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.impl;

import org.jboss.portal.cms.model.CMSObject;
import org.jboss.portal.cms.util.FileUtil;

import java.io.Serializable;
import java.util.Date;

public class CMSObjectImpl implements CMSObject, Serializable
{
   /** The serialVersionUID */
   private static final long serialVersionUID = -6475622589606925388L;

   protected String parentUUID;

   protected String name;
   protected String versionPath;
   protected String versionUUID;
   protected String basePath;
   protected String baseUUID;

   protected String description;
   protected String title;
   protected Date creationDate;
   protected Date lastModified;

   public String getParentUUID()
   {
      return parentUUID;
   }

   public void setParentUUID(String parentUUID)
   {
      this.parentUUID = parentUUID;
   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public String getVersionPath()
   {
      return versionPath;
   }

   public void setVersionPath(String versionPath)
   {
      this.versionPath = versionPath;
   }

   public String getVersionUUID()
   {
      return versionUUID;
   }

   public void setVersionUUID(String versionUUID)
   {
      this.versionUUID = versionUUID;
   }

   public String getBasePath()
   {
      return FileUtil.cleanDoubleSlashes(basePath);
   }

   public void setBasePath(String basePath)
   {      
      this.basePath = FileUtil.cleanDoubleSlashes(basePath);
   }

   public String getBaseUUID()
   {
      return baseUUID;
   }

   public void setBaseUUID(String baseUUID)
   {
      this.baseUUID = baseUUID;
   }

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String description)
   {
      this.description = description;
   }

   public String getTitle()
   {
      return title;
   }

   public void setTitle(String title)
   {
      this.title = title;
   }

   public Date getCreationDate()
   {
      return creationDate;
   }

   public void setCreationDate(Date creationDate)
   {
      this.creationDate = creationDate;
   }

   public Date getLastModified()
   {
      return lastModified;
   }

   public void setLastModified(Date lastModified)
   {
      this.lastModified = lastModified;
   }
}
