/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.hibernate.state;

import java.io.Serializable;

/*
 * Created on Aug 31, 2006
 *
 * @author <a href="mailto:sohil.shah@jboss.com">Sohil Shah</a>
 */
public abstract class Base implements Serializable
{
   /**
    *
    */
   private boolean persistCacheItem = true; //true by default...all items when placed in cache must be persisted to database by cacheloader by default
   private Integer key = null;

   /**
    *
    *
    */
   public Base()
   {

   }

   //------cacheItem Persistence related methods------------------------------------------------------------------------------------------------------
   /**
    *
    *
    */
   public void disableCacheItemPersistence()
   {
      this.persistCacheItem = false;
   }

   /**
    *
    *
    */
   public boolean isPersistCacheItem()
   {
      return this.persistCacheItem;
   }

   /**
    *
    *
    */
   public void resetCacheItemPersistence()
   {
      this.persistCacheItem = true;
   }

   //-----------data access related methods-------------------------------------------------------------------------------------------------------------
   public Integer getKey()
   {
      return key;
   }

   public void setKey(Integer key)
   {
      this.key = key;
   }
}
