/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 5806 $
 */
public class CMSException extends RuntimeException
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 3646107693814633408L;
   
   public static final int INVALID_ARCHIVE = 1;
   public static final int SERVICE_UNAVAILABLE=2;
   
   private int errorCode = 0;

   public CMSException()
   {
   }

   public CMSException(String message)
   {
      super(message);
   }

   public CMSException(String message, Throwable cause)
   {
      super(message, cause);
   }

   public CMSException(Throwable cause)
   {
      super(cause);
   }
   
   public CMSException(int errorCode)
   {
      this.errorCode = errorCode;
   }
   
   public boolean hasPathFormatFailure()
   {
      boolean pathFormatFailure = false;
      
      if(this.getMessage().indexOf("is not a legal path element")!=-1 || this.getMessage().indexOf("is not a valid path")!=-1)
      {
         pathFormatFailure = true;
      }
      
      return pathFormatFailure;
   }
   
   public boolean isServiceUnavailable()
   {
	   return (this.errorCode == SERVICE_UNAVAILABLE);
   }
   
   public String getMessageKey()
   {
      String key = "";
      
      switch(this.errorCode)
      {
         case INVALID_ARCHIVE:
            key = "INVALID_ARCHIVE_MESSAGE";
         break;
         
         case SERVICE_UNAVAILABLE:
        	key = "SERVICE_UNAVAILABLE";
         break;
         
         default:
              key = "";
         break;
      }
      
      return key;
   }
}
