/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.buildagent.api.httpinvoke;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import org.jboss.pnc.api.dto.HeartbeatConfig;
import org.jboss.pnc.api.dto.Request;

@JsonDeserialize(builder=Builder.class)
public class InvokeRequest {
    private final String command;
    private final Request callback;
    private final HeartbeatConfig heartbeatConfig;

    @Deprecated
    public InvokeRequest(String command, URL callbackUrl, String callbackMethod) {
        this.command = command;
        this.heartbeatConfig = null;
        try {
            this.callback = new Request(Request.Method.valueOf((String)callbackMethod), callbackUrl.toURI(), Collections.emptyList());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public InvokeRequest(String command, Request callback) {
        this.command = command;
        this.callback = callback;
        this.heartbeatConfig = null;
    }

    public InvokeRequest(String command, Request callback, HeartbeatConfig heartbeatConfig) {
        this.command = command;
        this.callback = callback;
        this.heartbeatConfig = heartbeatConfig;
    }

    private InvokeRequest(Builder builder) {
        this.command = builder.command;
        this.callback = builder.callback;
        this.heartbeatConfig = builder.heartbeatConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCommand() {
        return this.command;
    }

    public Request getCallback() {
        return this.callback;
    }

    public HeartbeatConfig getHeartbeatConfig() {
        return this.heartbeatConfig;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String command;
        private Request callback;
        private HeartbeatConfig heartbeatConfig;

        private Builder() {
        }

        public Builder command(String command) {
            this.command = command;
            return this;
        }

        public Builder callback(Request callback) {
            this.callback = callback;
            return this;
        }

        public Builder heartbeatConfig(HeartbeatConfig heartbeatConfig) {
            this.heartbeatConfig = heartbeatConfig;
            return this;
        }

        public InvokeRequest build() {
            return new InvokeRequest(this);
        }
    }
}

