/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.picketlink.idm.spi;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.jboss.picketlink.idm.model.Group;
import org.jboss.picketlink.idm.model.Membership;
import org.jboss.picketlink.idm.model.Role;
import org.jboss.picketlink.idm.model.User;
import org.jboss.picketlink.idm.query.GroupQuery;
import org.jboss.picketlink.idm.query.MembershipQuery;
import org.jboss.picketlink.idm.query.Range;
import org.jboss.picketlink.idm.query.RoleQuery;
import org.jboss.picketlink.idm.query.UserQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IdentityStore {
    public boolean validatePassword(User var1, String var2);

    public void updatePassword(User var1, String var2);

    public boolean validateCertificate(User var1, X509Certificate var2);

    public boolean updateCertificate(User var1, X509Certificate var2);

    public User createUser(String var1);

    public void removeUser(User var1);

    public User getUser(String var1);

    public Group createGroup(String var1, Group var2);

    public void removeGroup(Group var1);

    public Group getGroup(String var1);

    public Role createRole(String var1);

    public void removeRole(Role var1);

    public Role getRole(String var1);

    public Membership createMembership(Role var1, User var2, Group var3);

    public void removeMembership(Role var1, User var2, Group var3);

    public Membership getMembership(Role var1, User var2, Group var3);

    public List<User> executeQuery(UserQuery var1, Range var2);

    public List<Group> executeQuery(GroupQuery var1, Range var2);

    public List<Role> executeQuery(RoleQuery var1, Range var2);

    public List<Membership> executeQuery(MembershipQuery var1, Range var2);

    public void setAttribute(User var1, String var2, String[] var3);

    public void removeAttribute(User var1, String var2);

    public String[] getAttributeValues(User var1, String var2);

    public Map<String, String[]> getAttributes(User var1);

    public void setAttribute(Group var1, String var2, String[] var3);

    public void removeAttribute(Group var1, String var2);

    public String[] getAttributeValues(Group var1, String var2);

    public Map<String, String[]> getAttributes(Group var1);

    public void setAttribute(Role var1, String var2, String[] var3);

    public void removeAttribute(Role var1, String var2);

    public String[] getAttributeValues(Role var1, String var2);

    public Map<String, String[]> getAttributes(Role var1);

    public MembershipQuery createMembershipQuery();
}

