/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.httpservice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.osgi.httpservice.IOUtils;
import org.osgi.service.http.HttpContext;

final class ResourceServlet
extends HttpServlet {
    private final String name;
    private final HttpContext context;

    ResourceServlet(String name, HttpContext context) {
        this.name = name;
        this.context = context;
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        URL resurl = this.context.getResource(this.name + path);
        if (resurl == null) {
            res.sendError(404, req.getRequestURI());
        }
        URLConnection conn = resurl.openConnection();
        InputStream in = conn.getInputStream();
        if (conn.getContentLength() != -1) {
            res.setContentLength(conn.getContentLength());
        }
        if (conn.getContentType() != null) {
            res.setContentType(conn.getContentType());
        }
        if (conn.getContentEncoding() != null) {
            res.setCharacterEncoding(conn.getContentEncoding());
        }
        if (conn.getDate() != 0L) {
            res.setDateHeader("date", conn.getDate());
        }
        if (conn.getExpiration() != 0L) {
            res.setDateHeader("expires", conn.getExpiration());
        }
        if (conn.getLastModified() != 0L) {
            res.setDateHeader("last-modified", conn.getLastModified());
        }
        ServletOutputStream out = res.getOutputStream();
        IOUtils.copyStream((OutputStream)out, in);
    }
}

