/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.felix.webconsole.Action;
import org.apache.felix.webconsole.internal.BaseManagementPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class InstallAction
extends BaseManagementPlugin
implements Action {
    public static final String NAME = "install";
    public static final String LABEL = "Install or Update";
    public static final String FIELD_STARTLEVEL = "bundlestartlevel";
    public static final String FIELD_START = "bundlestart";
    public static final String FIELD_BUNDLEFILE = "bundlefile";
    public static final String FIELD_REFRESH_PACKAGES = "refreshPackages";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public boolean performAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        File tmpFile;
        String bundleLocation;
        int startLevel;
        FileItem refreshPackagesItem;
        FileItem bundleItem;
        FileItem startItem;
        block8: {
            Map params = (Map)request.getAttribute("org.apache.felix.webconsole.fileupload");
            if (params == null) {
                return true;
            }
            startItem = this.getFileItem(params, FIELD_START, true);
            FileItem startLevelItem = this.getFileItem(params, FIELD_STARTLEVEL, true);
            bundleItem = this.getFileItem(params, FIELD_BUNDLEFILE, false);
            refreshPackagesItem = this.getFileItem(params, FIELD_REFRESH_PACKAGES, true);
            if (bundleItem == null || bundleItem.getSize() <= 0L) {
                return true;
            }
            startLevel = -1;
            bundleLocation = "inputstream:";
            if (startLevelItem != null) {
                try {
                    startLevel = Integer.parseInt(startLevelItem.getString());
                }
                catch (NumberFormatException nfe) {
                    this.getLog().log(3, "Cannot parse start level parameter " + startLevelItem + " to a number, not setting start level");
                }
            }
            tmpFile = null;
            try {
                tmpFile = File.createTempFile(NAME, ".jar");
                bundleItem.write(tmpFile);
            }
            catch (Exception e) {
                this.getLog().log(1, "Problem accessing uploaded bundle file", e);
                if (tmpFile == null) break block8;
                tmpFile.delete();
                tmpFile = null;
            }
        }
        if (tmpFile != null) {
            boolean start = startItem != null;
            boolean refreshPackages = refreshPackagesItem != null;
            bundleLocation = "inputstream:" + bundleItem.getName();
            this.installBundle(bundleLocation, tmpFile, startLevel, start, refreshPackages);
        }
        return true;
    }

    private FileItem getFileItem(Map params, String name, boolean isFormField) {
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isFormField() != isFormField) continue;
                return items[i];
            }
        }
        return null;
    }

    protected void installBundle(String location, File bundleFile, int startLevel, boolean start, boolean refreshPackages) throws IOException {
        if (bundleFile != null) {
            String symbolicName = this.getSymbolicName(bundleFile);
            if (symbolicName == null) {
                bundleFile.delete();
                throw new IOException("Bundle-SymbolicName header missing, cannot install bundle");
            }
            Bundle updateBundle = null;
            if ("system.bundle".equals(symbolicName)) {
                updateBundle = this.getBundleContext().getBundle(0L);
            } else {
                Bundle[] bundles = this.getBundleContext().getBundles();
                for (int i = 0; i < bundles.length; ++i) {
                    if ((bundles[i].getLocation() == null || !bundles[i].getLocation().equals(location)) && (bundles[i].getSymbolicName() == null || !bundles[i].getSymbolicName().equals(symbolicName))) continue;
                    updateBundle = bundles[i];
                    break;
                }
            }
            if (updateBundle != null) {
                this.updateBackground(updateBundle, bundleFile, refreshPackages);
            } else {
                this.installBackground(bundleFile, location, startLevel, start, refreshPackages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSymbolicName(File bundleFile) {
        JarFile jar = null;
        try {
            jar = new JarFile(bundleFile);
            Manifest m = jar.getManifest();
            if (m != null) {
                String string = m.getMainAttributes().getValue("Bundle-SymbolicName");
                return string;
            }
        }
        catch (IOException ioe) {
            this.getLog().log(2, "Cannot extract symbolic name of bundle file " + bundleFile, ioe);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected void installBackground(File bundleFile, final String location, final int startlevel, final boolean doStart, boolean refreshPackages) {
        InstallHelper t = new InstallHelper(this, "Background Install " + bundleFile, bundleFile, refreshPackages){

            @Override
            protected Bundle doRun(InputStream bundleStream) throws BundleException {
                StartLevel sl;
                Bundle bundle = InstallAction.this.getBundleContext().installBundle(location, bundleStream);
                if (startlevel > 0 && (sl = InstallAction.this.getStartLevel()) != null) {
                    sl.setBundleStartLevel(bundle, startlevel);
                }
                if (doStart) {
                    bundle.start();
                }
                return bundle;
            }
        };
        t.start();
    }

    protected void updateBackground(final Bundle bundle, File bundleFile, boolean refreshPackages) {
        InstallHelper t = new InstallHelper(this, "Background Update" + bundle.getSymbolicName() + " (" + bundle.getBundleId() + ")", bundleFile, refreshPackages){

            @Override
            protected Bundle doRun(InputStream bundleStream) throws BundleException {
                bundle.update(bundleStream);
                return bundle;
            }
        };
        t.start();
    }

    public static abstract class InstallHelper
    extends Thread {
        private final InstallAction installAction;
        private final File bundleFile;
        private final boolean refreshPackages;

        public InstallHelper(InstallAction installAction, String name, File bundleFile, boolean refreshPackages) {
            super(name);
            this.setDaemon(true);
            this.installAction = installAction;
            this.bundleFile = bundleFile;
            this.refreshPackages = refreshPackages;
        }

        protected abstract Bundle doRun(InputStream var1) throws BundleException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.sleepSilently(500L);
            InputStream bundleStream = null;
            try {
                PackageAdmin pa = this.refreshPackages ? this.installAction.getPackageAdmin() : null;
                bundleStream = new FileInputStream(this.bundleFile);
                Bundle bundle = this.doRun(bundleStream);
                if (pa != null) {
                    this.sleepSilently(2000L);
                    pa.refreshPackages(new Bundle[]{bundle});
                }
            }
            catch (IOException ioe) {
                this.installAction.getLog().log(1, "Cannot install or update bundle from " + this.bundleFile, ioe);
            }
            catch (BundleException be) {
                this.installAction.getLog().log(1, "Cannot install or update bundle from " + this.bundleFile, be);
            }
            finally {
                if (bundleStream != null) {
                    try {
                        bundleStream.close();
                    }
                    catch (IOException ignore) {}
                }
                this.bundleFile.delete();
            }
        }

        protected void sleepSilently(long msecs) {
            try {
                InstallHelper.sleep(msecs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

