/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.StandardMBean;
import org.jboss.osgi.deployment.deployer.AbstractDeployerService;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentRegistryService;
import org.jboss.osgi.spi.util.ExportedPackageHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemDeployerService
extends AbstractDeployerService {
    private Logger log = LoggerFactory.getLogger(SystemDeployerService.class);
    private BundleContext context;
    private ServiceTracker startLevelTracker;

    public SystemDeployerService(BundleContext context) {
        this.context = context;
        ServiceTracker jmxTracker = new ServiceTracker(context, MBeanServer.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                MBeanServer mbeanServer = (MBeanServer)super.addingService(reference);
                SystemDeployerService.this.registerDeployerServiceMBean(this.context, mbeanServer);
                return mbeanServer;
            }

            public void removedService(ServiceReference reference, Object service) {
                MBeanServer mbeanServer = (MBeanServer)service;
                SystemDeployerService.this.unregisterDeployerServiceMBean(mbeanServer);
                super.removedService(reference, service);
            }
        };
        jmxTracker.open();
    }

    public void deploy(Deployment[] depArr) throws BundleException {
        DeploymentRegistryService registry = this.getDeploymentRegistry();
        ArrayList<Bundle> resolvableBundles = new ArrayList<Bundle>();
        HashMap<Deployment, Bundle> bundleMap = new HashMap<Deployment, Bundle>();
        for (Deployment dep : depArr) {
            try {
                this.log.debug("Install: " + dep.getLocation());
                String location = dep.getLocation().toExternalForm();
                Bundle bundle = this.context.installBundle(location);
                bundleMap.put(dep, bundle);
                if (dep.isAutoStart()) {
                    resolvableBundles.add(bundle);
                }
                registry.registerDeployment(dep);
            }
            catch (BundleException ex) {
                this.log.error("Cannot install bundle: " + dep, (Throwable)ex);
            }
        }
        ServiceReference packageAdminRef = this.context.getServiceReference(PackageAdmin.class.getName());
        if (packageAdminRef != null && !resolvableBundles.isEmpty()) {
            PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(packageAdminRef);
            Bundle[] resolvableBundleArr = new Bundle[resolvableBundles.size()];
            resolvableBundles.toArray(resolvableBundleArr);
            packageAdmin.resolveBundles(resolvableBundleArr);
        }
        for (Map.Entry entry : bundleMap.entrySet()) {
            int state;
            Deployment dep;
            dep = (Deployment)entry.getKey();
            Bundle bundle = (Bundle)entry.getValue();
            StartLevel startLevel = this.getStartLevel();
            if (dep.getStartLevel() > 0) {
                startLevel.setBundleStartLevel(bundle, dep.getStartLevel());
            }
            if (!dep.isAutoStart() || (state = bundle.getState()) != 4 && packageAdminRef != null) continue;
            try {
                this.log.debug("Start: " + bundle);
                bundle.start();
                ExportedPackageHelper packageHelper = new ExportedPackageHelper(this.context);
                packageHelper.logExportedPackages(bundle);
            }
            catch (BundleException ex) {
                this.log.error("Cannot start bundle: " + bundle, (Throwable)ex);
            }
        }
    }

    public void undeploy(Deployment[] depArr) throws BundleException {
        DeploymentRegistryService registry = this.getDeploymentRegistry();
        for (Deployment dep : depArr) {
            Bundle bundle = this.getBundle(dep);
            if (bundle != null) {
                this.log.debug("Uninstall: " + bundle);
                registry.unregisterDeployment(dep);
                bundle.uninstall();
                continue;
            }
            this.log.warn("Cannot obtain bundle for: " + dep);
        }
    }

    public void deploy(URL url) throws BundleException {
        Deployment dep = this.createDeployment(url);
        this.deploy(new Deployment[]{dep});
    }

    public void undeploy(URL url) throws BundleException {
        DeploymentRegistryService registry = this.getDeploymentRegistry();
        Deployment dep = registry.getDeployment(url);
        if (dep != null) {
            this.undeploy(new Deployment[]{dep});
        } else {
            this.log.warn("Cannot find deployment for: " + url);
        }
    }

    private Bundle getBundle(Deployment dep) {
        String symbolicName = dep.getSymbolicName();
        Version version = Version.parseVersion((String)dep.getVersion());
        Bundle bundle = null;
        for (Bundle aux : this.context.getBundles()) {
            Version auxVersion;
            if (!aux.getSymbolicName().equals(symbolicName) || !version.equals((Object)(auxVersion = aux.getVersion()))) continue;
            bundle = aux;
            break;
        }
        return bundle;
    }

    private DeploymentRegistryService getDeploymentRegistry() {
        ServiceReference sref = this.context.getServiceReference(DeploymentRegistryService.class.getName());
        if (sref == null) {
            throw new IllegalStateException("Cannot obtain DeploymentRegistryService");
        }
        return (DeploymentRegistryService)this.context.getService(sref);
    }

    private StartLevel getStartLevel() {
        if (this.startLevelTracker == null) {
            this.startLevelTracker = new ServiceTracker(this.context, StartLevel.class.getName(), null);
            this.startLevelTracker.open();
        }
        return (StartLevel)this.startLevelTracker.getService();
    }

    public void registerDeployerServiceMBean(BundleContext context, MBeanServer mbeanServer) {
        try {
            ServiceReference sref = context.getServiceReference(DeployerService.class.getName());
            if (sref == null) {
                throw new IllegalStateException("Cannot obtain deployer service");
            }
            if (mbeanServer.isRegistered(DeployerService.MBEAN_DEPLOYER_SERVICE)) {
                mbeanServer.unregisterMBean(DeployerService.MBEAN_DEPLOYER_SERVICE);
            }
            DeployerService service = (DeployerService)context.getService(sref);
            StandardMBean mbean = new StandardMBean(service, DeployerService.class);
            mbeanServer.registerMBean(mbean, DeployerService.MBEAN_DEPLOYER_SERVICE);
        }
        catch (JMException ex) {
            throw new IllegalStateException("Cannot register DeployerService MBean", ex);
        }
    }

    public void unregisterDeployerServiceMBean(MBeanServer mbeanServer) {
        try {
            if (mbeanServer.isRegistered(DeployerService.MBEAN_DEPLOYER_SERVICE)) {
                mbeanServer.unregisterMBean(DeployerService.MBEAN_DEPLOYER_SERVICE);
            }
        }
        catch (JMException ex) {
            this.log.error("Cannot unregister DeployerService MBean", (Throwable)ex);
        }
    }
}

