/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.jboss.logging.Logger;
import org.jboss.osgi.jmx.BundleStateMBeanExt;
import org.jboss.osgi.spi.util.UnmodifiableDictionary;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.OSGiRuntime;
import org.jboss.osgi.testing.internal.OSGiBundleImpl;
import org.jboss.osgi.testing.internal.OSGiRuntimeImpl;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.jmx.framework.BundleStateMBean;

class RemoteBundle
extends OSGiBundleImpl {
    private static final Logger log = Logger.getLogger(RemoteBundle.class);
    private long bundleId;
    private String location;
    private String symbolicName;
    private BundleStateMBeanExt bundleState;
    private Dictionary<String, String> defaultHeaders;
    private Dictionary<String, String> rawHeaders;
    private Version version;
    boolean uninstalled;

    RemoteBundle(OSGiRuntime runtime, long bundleId) throws IOException {
        super(runtime);
        this.bundleId = bundleId;
        this.bundleState = (BundleStateMBeanExt)runtime.getBundleStateMBean();
        this.symbolicName = this.bundleState.getSymbolicName(bundleId);
        this.location = this.bundleState.getLocation(bundleId);
        String versionStr = this.bundleState.getVersion(bundleId);
        this.version = Version.parseVersion((String)versionStr);
        this.defaultHeaders = this.getHeadersInternal(null);
        this.rawHeaders = this.getHeadersInternal("");
    }

    private Dictionary<String, String> getHeadersInternal(String locale) throws IOException {
        Hashtable<String, String> defaultHeaders = new Hashtable<String, String>();
        TabularData headers = this.bundleState.getHeaders(this.bundleId, locale);
        for (CompositeData aux : headers.values()) {
            String key = (String)aux.get("Key");
            String value = (String)aux.get("Value");
            ((Dictionary)defaultHeaders).put(key, value);
        }
        return new UnmodifiableDictionary(defaultHeaders);
    }

    @Override
    public int getState() {
        if (this.uninstalled) {
            return 1;
        }
        try {
            BundleStateMBean bundleState = this.getRuntime().getBundleStateMBean();
            String state = bundleState.getState(this.bundleId);
            if ("INSTALLED".equals(state)) {
                return 2;
            }
            if ("RESOLVED".equals(state)) {
                return 4;
            }
            if ("STARTING".equals(state)) {
                return 8;
            }
            if ("ACTIVE".equals(state)) {
                return 32;
            }
            if ("STOPPING".equals(state)) {
                return 16;
            }
            if ("UNINSTALLED".equals(state)) {
                return 1;
            }
            throw new IllegalStateException("Unsupported state: " + state);
        }
        catch (Exception rte) {
            Throwable cause;
            Throwable throwable = cause = rte.getCause() != null ? rte.getCause() : rte;
            if (!(cause instanceof InstanceNotFoundException)) {
                log.warn((Object)("Cannot get state for bundle: " + this), cause);
            }
            return 1;
        }
    }

    @Override
    public long getBundleId() {
        return this.bundleId;
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return new UnmodifiableDictionary(this.defaultHeaders);
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        if (locale == null) {
            return this.defaultHeaders;
        }
        if (locale.length() == 0) {
            return this.rawHeaders;
        }
        try {
            return this.getHeadersInternal(locale);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain headers for locale: " + locale, ex);
        }
    }

    @Override
    public String getProperty(String key) {
        this.assertNotUninstalled();
        try {
            CompositeData propData = this.bundleState.getProperty(this.bundleId, key);
            if (propData == null) {
                return null;
            }
            return (String)propData.get("Value");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain property: " + key, ex);
        }
    }

    @Override
    public URL getEntry(String path) {
        this.assertNotUninstalled();
        try {
            return this.toURL(this.bundleState.getEntry(this.bundleId, path), null);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot getEntry: " + path, ex);
        }
    }

    @Override
    public URL getResource(String name) {
        this.assertNotUninstalled();
        try {
            return this.toURL(this.bundleState.getResource(this.bundleId, name), null);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot getResource: " + name, ex);
        }
    }

    @Override
    public File getDataFile(String filename) {
        this.assertNotUninstalled();
        try {
            String filepath = this.bundleState.getDataFile(this.bundleId, filename);
            return filepath != null ? new File(filepath) : null;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot getDataFile: " + filename, ex);
        }
    }

    @Override
    public OSGiBundle loadClass(String name) throws ClassNotFoundException {
        this.assertNotUninstalled();
        try {
            long exporterId = this.bundleState.loadClass(this.bundleId, name);
            return this.getRuntime().getBundle(new Long(exporterId));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot loadClass: " + name, ex);
        }
    }

    @Override
    protected void startInternal() throws BundleException {
        this.assertNotUninstalled();
        try {
            this.getRuntime().getFrameworkMBean().startBundle(this.bundleId);
        }
        catch (IOException ex) {
            throw new BundleException("Cannot start bundle: " + this, (Throwable)ex);
        }
    }

    @Override
    protected void stopInternal() throws BundleException {
        this.assertNotUninstalled();
        try {
            this.getRuntime().getFrameworkMBean().stopBundle(this.bundleId);
        }
        catch (IOException ex) {
            throw new BundleException("Cannot stop bundle: " + this, (Throwable)ex);
        }
    }

    @Override
    protected void uninstallInternal() throws BundleException {
        this.assertNotUninstalled();
        try {
            this.getRuntime().getFrameworkMBean().uninstallBundle(this.bundleId);
            OSGiRuntimeImpl runtimeImpl = (OSGiRuntimeImpl)this.getRuntime();
            runtimeImpl.uninstallBundle(this);
            this.uninstalled = true;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            log.error((Object)("Cannot uninstall: " + this.getLocation()), (Throwable)ex);
        }
    }

    private URL toURL(String urlstr, URLStreamHandler sh) {
        if (urlstr == null) {
            return null;
        }
        try {
            return sh == null ? new URL(urlstr) : new URL(null, urlstr, sh);
        }
        catch (MalformedURLException ex) {
            if (sh == null && urlstr.startsWith("bundle")) {
                sh = new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL url) throws IOException {
                        return null;
                    }
                };
                return this.toURL(urlstr, sh);
            }
            throw new IllegalArgumentException("Invalid URL: " + urlstr);
        }
    }
}

