/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.capability.Capability;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.OSGiRuntimeHelper;
import org.jboss.osgi.testing.OSGiServiceReference;
import org.jboss.osgi.testing.internal.EmbeddedBundle;
import org.jboss.osgi.testing.internal.EmbeddedServiceReference;
import org.jboss.osgi.testing.internal.OSGiRuntimeImpl;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;

public class EmbeddedRuntime
extends OSGiRuntimeImpl {
    private static final Logger log = Logger.getLogger(EmbeddedRuntime.class);

    public EmbeddedRuntime(OSGiRuntimeHelper helper) {
        super(helper);
    }

    public static MBeanServer getLocalMBeanServer() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            log.warn((Object)("Multiple MBeanServer instances: " + serverArr));
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            log.debug((Object)("Found MBeanServer: " + mbeanServer));
        }
        if (mbeanServer == null) {
            log.debug((Object)"No MBeanServer, create one ...");
            mbeanServer = MBeanServerFactory.createMBeanServer();
            log.debug((Object)("Created MBeanServer: " + mbeanServer));
        }
        return mbeanServer;
    }

    @Override
    OSGiBundle installBundleInternal(BundleInfo info) throws BundleException {
        try {
            VirtualFile rootFile = info.getRoot();
            BundleContext context = this.getSystemContext();
            Bundle auxBundle = context.installBundle(info.getLocation(), rootFile.openStream());
            return new EmbeddedBundle(this, auxBundle);
        }
        catch (IOException ex) {
            throw new BundleException("Cannot install bundle: " + info, (Throwable)ex);
        }
    }

    @Override
    public OSGiBundle[] getBundles() {
        ArrayList<EmbeddedBundle> absBundles = new ArrayList<EmbeddedBundle>();
        for (Bundle bundle : this.getSystemContext().getBundles()) {
            absBundles.add(new EmbeddedBundle(this, bundle));
        }
        OSGiBundle[] bundleArr = new OSGiBundle[absBundles.size()];
        absBundles.toArray(bundleArr);
        return bundleArr;
    }

    @Override
    public OSGiBundle getBundle(long bundleId) {
        Bundle bundle = this.getSystemContext().getBundle(bundleId);
        return bundle != null ? new EmbeddedBundle(this, bundle) : null;
    }

    @Override
    public OSGiServiceReference getServiceReference(String clazz) {
        ServiceReference sref = this.getSystemContext().getServiceReference(clazz);
        return sref != null ? new EmbeddedServiceReference(sref) : null;
    }

    @Override
    public OSGiServiceReference[] getServiceReferences(String clazz, String filter) {
        ServiceReference[] srefs;
        OSGiServiceReference[] retRefs = null;
        try {
            srefs = this.getSystemContext().getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter syntax: " + filter);
        }
        if (srefs != null) {
            retRefs = new OSGiServiceReference[srefs.length];
            for (int i = 0; i < srefs.length; ++i) {
                retRefs[i] = new EmbeddedServiceReference(srefs[i]);
            }
        }
        return retRefs;
    }

    @Override
    public void addCapability(Capability capability) throws BundleException {
        Map<String, String> props = capability.getSystemProperties();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String value = System.getProperty(entry.getKey());
            if (value != null) continue;
            System.setProperty(entry.getKey(), entry.getValue());
        }
        super.addCapability(capability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        OSGiBootstrapProvider bootProvider = this.getTestHelper().getBootstrapProvider();
        if (bootProvider != null) {
            super.shutdown();
            try {
                Framework framework = bootProvider.getFramework();
                log.debug((Object)("Framework stop: " + framework));
                framework.stop();
                framework.waitForStop(5000L);
            }
            catch (Exception ex) {
                log.error((Object)"Cannot stop the framework", (Throwable)ex);
            }
            finally {
                this.getTestHelper().ungetBootstrapProvider();
            }
        }
    }

    @Override
    public MBeanServerConnection getMBeanServer() {
        return EmbeddedRuntime.getLocalMBeanServer();
    }

    @Override
    public boolean isRemoteRuntime() {
        return false;
    }

    BundleContext getSystemContext() {
        OSGiBootstrapProvider bootProvider = this.getTestHelper().getBootstrapProvider();
        Framework framework = bootProvider.getFramework();
        if (framework.getState() != 32) {
            try {
                log.debug((Object)("Framework start: " + framework));
                framework.start();
            }
            catch (BundleException ex) {
                throw new IllegalStateException("Cannot start framework", ex);
            }
        }
        return framework.getBundleContext();
    }
}

