/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.framework.OSGiBootstrap;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.util.ConstantsHelper;
import org.jboss.osgi.testing.OSGiTest;
import org.jboss.osgi.testing.OSGiTestHelper;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.launch.Framework;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OSGiFrameworkTest
extends OSGiTest
implements ServiceListener,
SynchronousBundleListener,
FrameworkListener {
    private static final Logger log = Logger.getLogger(OSGiFrameworkTest.class);
    protected static Framework framework;
    protected static BundleContext systemContext;
    private final List<FrameworkEvent> frameworkEvents = new CopyOnWriteArrayList<FrameworkEvent>();
    private final List<BundleEvent> bundleEvents = new CopyOnWriteArrayList<BundleEvent>();
    private final List<ServiceEvent> serviceEvents = new CopyOnWriteArrayList<ServiceEvent>();

    @BeforeClass
    public static void beforeClass() throws Exception {
        OSGiBootstrapProvider bootProvider = OSGiBootstrap.getBootstrapProvider();
        framework = bootProvider.getFramework();
        framework.start();
        systemContext = framework.getBundleContext();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (framework != null) {
            framework.stop();
            framework.waitForStop(2000L);
            framework = null;
        }
    }

    protected PackageAdmin getPackageAdmin() {
        ServiceReference sref = systemContext.getServiceReference(PackageAdmin.class.getName());
        return (PackageAdmin)systemContext.getService(sref);
    }

    protected Bundle installBundle(Archive<?> archive) throws BundleException, IOException {
        VirtualFile virtualFile = OSGiTestHelper.toVirtualFile(archive);
        return this.installBundle(archive.getName(), virtualFile.openStream());
    }

    protected Bundle installBundle(VirtualFile virtualFile) throws BundleException, IOException {
        String location = virtualFile.getPathName();
        return this.installBundle(location, virtualFile.openStream());
    }

    protected Bundle installBundle(String location) throws BundleException, IOException {
        URL bundleURL = this.getTestHelper().getTestArchiveURL(location);
        VirtualFile virtualFile = AbstractVFS.getRoot((URL)bundleURL);
        return this.installBundle(location, virtualFile.openStream());
    }

    protected Bundle installBundle(String location, InputStream inputStream) throws BundleException {
        return systemContext.installBundle(location, inputStream);
    }

    protected void assertLoadClass(Bundle bundle, String className, Bundle exporter) {
        Class<?> clazz = this.assertLoadClass(bundle, className);
        Bundle actual = this.getPackageAdmin().getBundle(clazz);
        Assert.assertEquals((String)"Loaded from ClassLoader", (Object)exporter, (Object)actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent event) {
        List<FrameworkEvent> list = this.frameworkEvents;
        synchronized (list) {
            log.debug((Object)("FrameworkEvent type=" + ConstantsHelper.frameworkEvent(event.getType()) + " for " + event));
            this.frameworkEvents.add(event);
            this.frameworkEvents.notifyAll();
        }
    }

    protected void assertNoFrameworkEvent() throws Exception {
        log.debug((Object)("frameworkEvents=" + this.frameworkEvents));
        Assert.assertEquals((long)0L, (long)this.frameworkEvents.size());
    }

    protected void assertFrameworkEvent(int type, Bundle bundle, Class<? extends Throwable> expectedThrowable) throws Exception {
        this.waitForEvent(this.frameworkEvents, type);
        log.debug((Object)("frameworkEvents=" + this.frameworkEvents));
        int size = this.frameworkEvents.size();
        Assert.assertTrue((String)("" + size), (size > 0 ? 1 : 0) != 0);
        FrameworkEvent event = this.frameworkEvents.remove(0);
        Assert.assertEquals((Object)ConstantsHelper.frameworkEvent(type), (Object)ConstantsHelper.frameworkEvent(event.getType()));
        Throwable t = event.getThrowable();
        if (expectedThrowable == null) {
            if (t != null) {
                log.error((Object)"Unexpected error in Framework event: ", t);
                Assert.fail((String)("Unexpected throwable: " + t));
            }
        } else {
            String message = expectedThrowable.getSimpleName() + " is assignable from " + t.getClass().getSimpleName();
            Assert.assertTrue((String)message, (boolean)expectedThrowable.isAssignableFrom(t.getClass()));
        }
        Assert.assertEquals((Object)bundle, (Object)event.getSource());
        Assert.assertEquals((Object)bundle, (Object)event.getBundle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        List<BundleEvent> list = this.bundleEvents;
        synchronized (list) {
            log.debug((Object)("BundleChanged type=" + ConstantsHelper.bundleEvent(event.getType()) + " for " + event));
            this.bundleEvents.add(event);
            this.bundleEvents.notifyAll();
        }
    }

    protected void assertNoBundleEvent() throws Exception {
        log.debug((Object)("bundleEvents=" + this.bundleEvents));
        Assert.assertEquals((long)0L, (long)this.bundleEvents.size());
    }

    protected void assertBundleEvent(int type, Bundle bundle) throws Exception {
        this.waitForEvent(this.bundleEvents, type);
        log.debug((Object)("bundleEvents=" + this.bundleEvents));
        int size = this.bundleEvents.size();
        Assert.assertTrue((String)("" + size), (size > 0 ? 1 : 0) != 0);
        BundleEvent foundEvent = null;
        for (int i = 0; i < this.bundleEvents.size(); ++i) {
            BundleEvent aux = this.bundleEvents.get(i);
            if (type != aux.getType() || !bundle.equals(aux.getSource()) || !bundle.equals(aux.getBundle())) continue;
            this.bundleEvents.remove(aux);
            foundEvent = aux;
            break;
        }
        if (foundEvent == null) {
            Assert.fail((String)("Cannot find event " + ConstantsHelper.bundleEvent(type) + " from " + bundle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        List<ServiceEvent> list = this.serviceEvents;
        synchronized (list) {
            log.debug((Object)("ServiceChanged type=" + ConstantsHelper.serviceEvent(event.getType()) + " for " + event));
            this.serviceEvents.add(event);
            this.serviceEvents.notifyAll();
        }
    }

    protected void assertNoServiceEvent() throws Exception {
        log.debug((Object)("serviceEvents=" + this.serviceEvents));
        Assert.assertEquals((long)0L, (long)this.serviceEvents.size());
    }

    protected void assertServiceEvent(int type, ServiceReference reference) throws Exception {
        this.waitForEvent(this.serviceEvents, type);
        log.debug((Object)("serviceEvents=" + this.serviceEvents));
        int size = this.serviceEvents.size();
        Assert.assertTrue((String)("" + size), (size > 0 ? 1 : 0) != 0);
        ServiceEvent event = this.serviceEvents.remove(0);
        Assert.assertEquals((Object)ConstantsHelper.serviceEvent(type), (Object)ConstantsHelper.serviceEvent(event.getType()));
        Assert.assertEquals((Object)reference, (Object)event.getSource());
        Assert.assertEquals((Object)reference, (Object)event.getServiceReference());
    }

    protected void assertNoAllReferences(BundleContext bundleContext, String clazz) throws Exception {
        this.assertNoAllReferences(bundleContext, clazz, null);
    }

    protected void assertNoAllReferences(BundleContext bundleContext, String clazz, String filter) throws Exception {
        ServiceReference[] actual = bundleContext.getAllServiceReferences(clazz, filter);
        if (actual != null) {
            log.debug((Object)(bundleContext + " got " + Arrays.asList(actual) + " for clazz=" + clazz + " filter=" + filter));
        } else {
            log.debug((Object)(bundleContext + " got nothing for clazz=" + clazz + " filter=" + filter));
        }
        Assert.assertNull((String)("Expected no references for clazz=" + clazz + " filter=" + filter), (Object)actual);
    }

    protected void assertAllReferences(BundleContext bundleContext, String clazz, ServiceReference ... expected) throws Exception {
        this.assertAllReferences(bundleContext, clazz, (String)null, expected);
    }

    protected void assertAllReferences(BundleContext bundleContext, String clazz, String filter, ServiceReference ... expected) throws Exception {
        Object[] actual = bundleContext.getAllServiceReferences(clazz, filter);
        if (actual != null) {
            log.debug((Object)(bundleContext + " got " + Arrays.asList(actual) + " for clazz=" + clazz + " filter=" + filter));
        } else {
            log.debug((Object)(bundleContext + " got nothing for clazz=" + clazz + " filter=" + filter));
        }
        Assert.assertArrayEquals((String)(bundleContext + " with clazz=" + clazz + " filter=" + filter), (Object[])expected, (Object[])actual);
    }

    protected void assertNoReferences(BundleContext bundleContext, String clazz) throws Exception {
        this.assertNoReferences(bundleContext, clazz, null);
    }

    protected void assertNoReferences(BundleContext bundleContext, String clazz, String filter) throws Exception {
        ServiceReference[] actual = bundleContext.getServiceReferences(clazz, filter);
        if (actual != null) {
            log.debug((Object)(bundleContext + " got " + Arrays.asList(actual) + " for clazz=" + clazz + " filter=" + filter));
        } else {
            log.debug((Object)(bundleContext + " got nothing for clazz=" + clazz + " filter=" + filter));
        }
        Assert.assertNull((String)("Expected no references for clazz=" + clazz + " filter=" + filter), (Object)actual);
    }

    protected void assertReferences(BundleContext bundleContext, String clazz, ServiceReference ... expected) throws Exception {
        this.assertReferences(bundleContext, clazz, (String)null, expected);
    }

    protected void assertReferences(BundleContext bundleContext, String clazz, String filter, ServiceReference ... expected) throws Exception {
        Object[] actual = bundleContext.getServiceReferences(clazz, filter);
        if (actual != null) {
            log.debug((Object)(bundleContext + " got " + Arrays.asList(actual) + " for clazz=" + clazz + " filter=" + filter));
        } else {
            log.debug((Object)(bundleContext + " got nothing for clazz=" + clazz + " filter=" + filter));
        }
        Assert.assertArrayEquals((String)(bundleContext + " with clazz=" + clazz + " filter=" + filter), (Object[])expected, (Object[])actual);
    }

    protected void assertNoGetReference(BundleContext bundleContext, String clazz) throws Exception {
        ServiceReference actual = bundleContext.getServiceReference(clazz);
        if (actual != null) {
            log.debug((Object)(bundleContext + " got " + actual + " for clazz=" + clazz));
        } else {
            log.debug((Object)(bundleContext + " got nothing for clazz=" + clazz));
        }
        Assert.assertNull((String)("Expected no references for clazz=" + clazz), (Object)actual);
    }

    protected void assertGetReference(BundleContext bundleContext, String clazz, ServiceReference expected) throws Exception {
        ServiceReference actual = bundleContext.getServiceReference(clazz);
        if (actual != null) {
            log.debug((Object)(bundleContext + " got " + Arrays.asList(actual) + " for clazz=" + clazz));
        } else {
            log.debug((Object)(bundleContext + " got nothing for clazz=" + clazz));
        }
        Assert.assertEquals((String)(bundleContext + " with clazz=" + clazz), (Object)expected, (Object)actual);
    }

    protected void assertUsingBundles(ServiceReference reference, Bundle ... bundles) {
        HashSet<Bundle> actual = new HashSet<Bundle>();
        Bundle[] users = reference.getUsingBundles();
        if (users != null) {
            actual.addAll(Arrays.asList(users));
        }
        HashSet<Bundle> expected = new HashSet<Bundle>();
        expected.addAll(Arrays.asList(bundles));
        log.debug((Object)(reference + " users=" + actual));
        Assert.assertEquals(actual, expected);
    }

    protected <T> T assertInstanceOf(Object o, Class<T> expectedType) {
        return this.assertInstanceOf(o, expectedType, false);
    }

    protected <T> T assertInstanceOf(Object o, Class<T> expectedType, boolean allowNull) {
        if (expectedType == null) {
            Assert.fail((String)"Null expectedType");
        }
        if (o == null) {
            if (!allowNull) {
                Assert.fail((String)"Null object not allowed.");
            } else {
                return null;
            }
        }
        try {
            return expectedType.cast(o);
        }
        catch (ClassCastException e) {
            Assert.fail((String)("Object " + o + " of class " + o.getClass().getName() + " is not an instanceof " + expectedType.getName()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEvent(List events, int type) throws InterruptedException {
        boolean eventFound = false;
        for (int timeout = 30; !eventFound && 0 < timeout; --timeout) {
            List list = events;
            synchronized (list) {
                events.wait(100L);
                for (Object aux : events) {
                    BundleEvent event;
                    if (aux instanceof BundleEvent) {
                        event = (BundleEvent)aux;
                        if (type != event.getType()) continue;
                        eventFound = true;
                        break;
                    }
                    if (aux instanceof ServiceEvent) {
                        event = (ServiceEvent)aux;
                        if (type != event.getType()) continue;
                        eventFound = true;
                        break;
                    }
                    if (!(aux instanceof FrameworkEvent) || type != (event = (FrameworkEvent)aux).getType()) continue;
                    eventFound = true;
                    break;
                }
                continue;
            }
        }
    }
}

