/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.util;

import java.util.ArrayList;
import java.util.Collections;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExportedPackageHelper {
    final Logger log = LoggerFactory.getLogger(ExportedPackageHelper.class);
    private PackageAdmin packageAdmin;

    public ExportedPackageHelper(BundleContext context) {
        ServiceReference sref = context.getServiceReference(PackageAdmin.class.getName());
        if (sref != null) {
            this.packageAdmin = (PackageAdmin)context.getService(sref);
        }
    }

    public boolean resolveBundle(Bundle bundle) {
        return this.packageAdmin != null ? this.packageAdmin.resolveBundles(new Bundle[]{bundle}) : false;
    }

    public boolean resolveBundles(Bundle[] bundles) {
        return this.packageAdmin != null ? this.packageAdmin.resolveBundles(bundles) : false;
    }

    public void logExportedPackages(Bundle bundle) {
        if (this.packageAdmin != null) {
            this.log.debug("Exported-Packages: " + bundle.getSymbolicName());
            ExportedPackage[] exportedPackages = this.packageAdmin.getExportedPackages(bundle);
            if (exportedPackages != null) {
                ArrayList<String> packages = new ArrayList<String>();
                for (ExportedPackage exp : exportedPackages) {
                    packages.add("  " + exp.getName() + ";version=" + exp.getVersion());
                }
                Collections.sort(packages);
                for (String exp : packages) {
                    this.log.debug(exp);
                }
            }
        }
    }
}

