/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.management;

import java.io.File;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.ObjectName;
import org.jboss.osgi.spi.management.ManagedBundleMBean;
import org.jboss.osgi.spi.management.ObjectNameFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBundle
implements ManagedBundleMBean {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_SYMBOLIC_NAME = "name";
    public static final String PROPERTY_VERSION = "version";
    private BundleContext systemContext;
    private Bundle bundle;
    private ObjectName oname;

    public ManagedBundle(BundleContext context, Bundle bundle) {
        if (context == null) {
            throw new IllegalArgumentException("Null system context");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        this.bundle = bundle;
        this.systemContext = context;
        this.oname = ManagedBundle.getObjectName(bundle);
    }

    public static ObjectName getObjectName(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        long id = bundle.getBundleId();
        String name = bundle.getSymbolicName();
        Version version = bundle.getVersion();
        return ManagedBundle.getObjectName(id, name, version);
    }

    public static ObjectName getObjectName(long id, String name, Version version) {
        String oname = "jboss.osgi:id=" + id + "," + PROPERTY_SYMBOLIC_NAME + "=" + name + "," + PROPERTY_VERSION + "=" + version;
        return ObjectNameFactory.create(oname);
    }

    @Override
    public ObjectName getObjectName() {
        return this.oname;
    }

    @Override
    public String getProperty(String key) {
        return this.bundle.getBundleContext().getProperty(key);
    }

    @Override
    public int getState() {
        return this.bundle.getState();
    }

    @Override
    public long getBundleId() {
        return this.bundle.getBundleId();
    }

    @Override
    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    @Override
    public String getLocation() {
        return this.bundle.getLocation();
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(null);
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        Hashtable<String, String> retHeaders = new Hashtable<String, String>();
        Dictionary bundleHeaders = this.bundle.getHeaders(locale);
        Enumeration keys = bundleHeaders.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)bundleHeaders.get(key);
            retHeaders.put(key, value);
        }
        return retHeaders;
    }

    @Override
    public String getEntry(String path) {
        URL url = this.bundle.getEntry(path);
        return url != null ? url.toExternalForm() : null;
    }

    @Override
    public String getResource(String name) {
        URL url = this.bundle.getResource(name);
        return url != null ? url.toExternalForm() : null;
    }

    @Override
    public ObjectName loadClass(String name) throws ClassNotFoundException {
        Class clazz = this.bundle.loadClass(name);
        Bundle providingBundle = this.getPackageAdmin().getBundle(clazz);
        return providingBundle != null ? ManagedBundle.getObjectName(providingBundle) : null;
    }

    @Override
    public File getDataFile(String filename) {
        BundleContext context = this.bundle.getBundleContext();
        return context.getDataFile(filename);
    }

    @Override
    public void start() throws BundleException {
        this.bundle.start();
    }

    @Override
    public void stop() throws BundleException {
        this.bundle.stop();
    }

    @Override
    public void update() throws BundleException {
        this.bundle.update();
    }

    private PackageAdmin getPackageAdmin() {
        ServiceReference sref = this.systemContext.getServiceReference(PackageAdmin.class.getName());
        return (PackageAdmin)this.systemContext.getService(sref);
    }
}

