/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.management;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import org.jboss.osgi.spi.management.MBeanProxyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanProxy {
    public static <T> T get(Class<T> interf, ObjectName name, MBeanServerConnection server) throws MBeanProxyException {
        return (T)MBeanProxy.get(new Class[]{interf}, name, server);
    }

    public static Object get(Class[] interfaces, ObjectName name, MBeanServerConnection server) throws MBeanProxyException {
        if (interfaces == null || interfaces.length == 0) {
            throw new IllegalArgumentException("Null interfaces");
        }
        ClassLoader classLoader = interfaces[0].getClassLoader();
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new JMXInvocationHandler(server, name));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JMXInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 3714728148040623702L;
        protected MBeanServerConnection server = null;
        protected ObjectName objectName = null;
        private HashMap<String, MBeanAttributeInfo> attributeMap = new HashMap();
        private boolean delegateToStringToResource = false;
        private boolean delegateEqualsToResource = false;
        private boolean delegateHashCodeToResource = false;

        public JMXInvocationHandler(MBeanServerConnection server, ObjectName name) throws MBeanProxyException {
            try {
                int i;
                if (server == null) {
                    throw new MBeanProxyException("null agent reference");
                }
                if (name == null) {
                    throw new MBeanProxyException("null object name");
                }
                this.server = server;
                this.objectName = name;
                MBeanInfo info = server.getMBeanInfo(this.objectName);
                MBeanAttributeInfo[] attributes = info.getAttributes();
                MBeanOperationInfo[] operations = info.getOperations();
                for (i = 0; i < attributes.length; ++i) {
                    this.attributeMap.put(attributes[i].getName(), attributes[i]);
                }
                for (i = 0; i < operations.length; ++i) {
                    if (operations[i].getName().equals("toString") && operations[i].getReturnType().equals("java.lang.String") && operations[i].getSignature().length == 0) {
                        this.delegateToStringToResource = true;
                        continue;
                    }
                    if (operations[i].getName().equals("equals") && operations[i].getReturnType().equals(Boolean.TYPE.getName()) && operations[i].getSignature().length == 1 && operations[i].getSignature()[0].getType().equals("java.lang.Object")) {
                        this.delegateEqualsToResource = true;
                        continue;
                    }
                    if (!operations[i].getName().equals("hashCode") || !operations[i].getReturnType().equals(Integer.TYPE.getName()) || operations[i].getSignature().length != 0) continue;
                    this.delegateHashCodeToResource = true;
                }
            }
            catch (InstanceNotFoundException e) {
                throw new MBeanProxyException("Object name " + name + " not found: " + e.toString());
            }
            catch (Exception ex) {
                throw new MBeanProxyException(ex.toString());
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == Object.class) {
                return this.handleObjectMethods(method, args);
            }
            try {
                Object retType;
                MBeanAttributeInfo info;
                String attrName;
                String methodName = method.getName();
                if (methodName.startsWith("get") && args == null) {
                    attrName = methodName.substring(3, methodName.length());
                    info = this.attributeMap.get(attrName);
                    if (info != null && ((String)(retType = method.getReturnType().getName())).equals(info.getType())) {
                        return this.server.getAttribute(this.objectName, attrName);
                    }
                } else if (methodName.startsWith("is") && args == null) {
                    attrName = methodName.substring(2, methodName.length());
                    info = this.attributeMap.get(attrName);
                    if (info != null && info.isIs() && ((retType = method.getReturnType()).equals(Boolean.class) || retType.equals(Boolean.TYPE))) {
                        return this.server.getAttribute(this.objectName, attrName);
                    }
                } else if (methodName.startsWith("set") && args != null && args.length == 1 && (info = this.attributeMap.get(attrName = methodName.substring(3, methodName.length()))) != null && method.getReturnType().equals(Void.TYPE)) {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> signatureClass = null;
                    String classType = info.getType();
                    signatureClass = this.isPrimitive(classType) ? this.getPrimitiveClass(classType) : cl.loadClass(info.getType());
                    if (signatureClass.isAssignableFrom(args[0].getClass())) {
                        this.server.setAttribute(this.objectName, new Attribute(attrName, args[0]));
                        return null;
                    }
                }
                String[] signature = null;
                if (args != null) {
                    signature = new String[args.length];
                    Class<?>[] sign = method.getParameterTypes();
                    for (int i = 0; i < sign.length; ++i) {
                        signature[i] = sign[i].getName();
                    }
                }
                return this.server.invoke(this.objectName, methodName, args, signature);
            }
            catch (Exception ex) {
                throw (Exception)this.decodeJMXException(ex);
            }
        }

        private Throwable decodeJMXException(Exception ex) {
            Throwable result = ex;
            while (true) {
                if (result instanceof MBeanException) {
                    result = ((MBeanException)result).getTargetException();
                    continue;
                }
                if (result instanceof ReflectionException) {
                    result = ((ReflectionException)result).getTargetException();
                    continue;
                }
                if (result instanceof RuntimeOperationsException) {
                    result = ((RuntimeOperationsException)result).getTargetException();
                    continue;
                }
                if (result instanceof RuntimeMBeanException) {
                    result = ((RuntimeMBeanException)result).getTargetException();
                    continue;
                }
                if (result instanceof RuntimeErrorException) {
                    result = ((RuntimeErrorException)result).getTargetError();
                    continue;
                }
                if (!(result instanceof UndeclaredThrowableException)) break;
                result = ((UndeclaredThrowableException)result).getUndeclaredThrowable();
            }
            return result;
        }

        private Object handleObjectMethods(Method method, Object[] args) throws Exception {
            if (method.getName().equals("toString")) {
                if (this.delegateToStringToResource) {
                    return this.server.invoke(this.objectName, "toString", null, null);
                }
                return this.toString();
            }
            if (method.getName().equals("equals")) {
                if (this.delegateEqualsToResource) {
                    return this.server.invoke(this.objectName, "equals", new Object[]{args[0]}, new String[]{"java.lang.Object"});
                }
                if (Proxy.isProxyClass(args[0].getClass())) {
                    Proxy prxy = (Proxy)args[0];
                    return new Boolean(this.equals(Proxy.getInvocationHandler(prxy)));
                }
                return new Boolean(this.equals(args[0]));
            }
            if (method.getName().equals("hashCode")) {
                if (this.delegateHashCodeToResource) {
                    return this.server.invoke(this.objectName, "hashCode", null, null);
                }
                return new Integer(this.hashCode());
            }
            throw new Error("Unexpected method invocation!");
        }

        private boolean isPrimitive(String type) {
            if (type.equals(Integer.TYPE.getName())) {
                return true;
            }
            if (type.equals(Long.TYPE.getName())) {
                return true;
            }
            if (type.equals(Boolean.TYPE.getName())) {
                return true;
            }
            if (type.equals(Byte.TYPE.getName())) {
                return true;
            }
            if (type.equals(Character.TYPE.getName())) {
                return true;
            }
            if (type.equals(Short.TYPE.getName())) {
                return true;
            }
            if (type.equals(Float.TYPE.getName())) {
                return true;
            }
            if (type.equals(Double.TYPE.getName())) {
                return true;
            }
            return type.equals(Void.TYPE.getName());
        }

        private Class<?> getPrimitiveClass(String type) {
            if (type.equals(Integer.TYPE.getName())) {
                return Integer.TYPE;
            }
            if (type.equals(Long.TYPE.getName())) {
                return Long.TYPE;
            }
            if (type.equals(Boolean.TYPE.getName())) {
                return Boolean.TYPE;
            }
            if (type.equals(Byte.TYPE.getName())) {
                return Byte.TYPE;
            }
            if (type.equals(Character.TYPE.getName())) {
                return Character.TYPE;
            }
            if (type.equals(Short.TYPE.getName())) {
                return Short.TYPE;
            }
            if (type.equals(Float.TYPE.getName())) {
                return Float.TYPE;
            }
            if (type.equals(Double.TYPE.getName())) {
                return Double.TYPE;
            }
            if (type.equals(Void.TYPE.getName())) {
                return Void.TYPE;
            }
            return null;
        }
    }
}

