/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.management;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.ObjectName;
import org.jboss.osgi.spi.management.ManagedBundleMBean;
import org.jboss.osgi.spi.management.ObjectNameFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBundle
implements ManagedBundleMBean {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_SYMBOLIC_NAME = "name";
    public static final String PROPERTY_VERSION = "version";
    private Bundle bundle;
    private ObjectName oname;

    public ManagedBundle(Bundle bundle) {
        this.bundle = bundle;
        this.oname = ManagedBundle.getObjectName(bundle);
    }

    public static ObjectName getObjectName(Bundle bundle) {
        long id = bundle.getBundleId();
        String name = bundle.getSymbolicName();
        Version version = bundle.getVersion();
        return ManagedBundle.getObjectName(id, name, version);
    }

    public static ObjectName getObjectName(long id, String name, Version version) {
        String oname = "jboss.osgi:id=" + id + "," + PROPERTY_SYMBOLIC_NAME + "=" + name + "," + PROPERTY_VERSION + "=" + version;
        return ObjectNameFactory.create(oname);
    }

    @Override
    public ObjectName getObjectName() {
        return this.oname;
    }

    @Override
    public String getProperty(String key) {
        return this.bundle.getBundleContext().getProperty(key);
    }

    @Override
    public int getState() {
        return this.bundle.getState();
    }

    @Override
    public long getBundleId() {
        return this.bundle.getBundleId();
    }

    @Override
    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        Hashtable<String, String> retHeaders = new Hashtable<String, String>();
        Dictionary bundleHeaders = this.bundle.getHeaders();
        Enumeration keys = bundleHeaders.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)bundleHeaders.get(key);
            retHeaders.put(key, value);
        }
        return retHeaders;
    }

    @Override
    public void start() throws BundleException {
        this.bundle.start();
    }

    @Override
    public void stop() throws BundleException {
        this.bundle.stop();
    }

    @Override
    public void update() throws BundleException {
        this.bundle.update();
    }
}

