/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.capability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.spi.util.BundleInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Capability {
    private String serviceName;
    private String filter;
    private Map<String, String> systemProperties;
    private List<Capability> dependencies;
    private List<BundleInfo> bundles;

    public Capability(String serviceName) {
        this(serviceName, null);
    }

    public Capability(String serviceName, String filter) {
        this.serviceName = serviceName;
        this.filter = filter;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void addSystemProperty(String key, String value) {
        this.getPropertiesInternal().put(key, value);
    }

    public Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(this.getPropertiesInternal());
    }

    public List<Capability> getDependencies() {
        return Collections.unmodifiableList(this.getDependenciesInternal());
    }

    protected void addDependency(Capability dependency) {
        this.getDependenciesInternal().add(dependency);
    }

    public List<BundleInfo> getBundles() {
        return Collections.unmodifiableList(this.getBundlesInternal());
    }

    protected void addBundle(String location) {
        BundleInfo info = BundleInfo.createBundleInfo(location);
        this.getBundlesInternal().add(info);
    }

    private Map<String, String> getPropertiesInternal() {
        if (this.systemProperties == null) {
            this.systemProperties = new HashMap<String, String>();
        }
        return this.systemProperties;
    }

    private List<Capability> getDependenciesInternal() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Capability>();
        }
        return this.dependencies;
    }

    private List<BundleInfo> getBundlesInternal() {
        if (this.bundles == null) {
            this.bundles = new ArrayList<BundleInfo>();
        }
        return this.bundles;
    }
}

