/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.testing;

import java.io.File;
import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.testing.OSGiRuntime;
import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.jboss.virtual.VFS;
import org.junit.After;
import org.junit.Before;

public abstract class OSGiTest {
    final Logger log = Logger.getLogger(OSGiTest.class);
    private OSGiTestHelper helper;

    protected OSGiTest() {
        VFS.init();
    }

    protected OSGiTestHelper getTestHelper() {
        if (this.helper == null) {
            this.helper = new OSGiTestHelper();
        }
        return this.helper;
    }

    @Before
    public void setUp() throws Exception {
        this.log.debug((Object)("### START " + this.getLongName()));
    }

    @After
    public void tearDown() throws Exception {
        this.log.debug((Object)("### END " + this.getLongName()));
    }

    protected String getShortName() {
        String shortName = this.getClass().getName();
        shortName = shortName.substring(shortName.lastIndexOf(".") + 1);
        return shortName;
    }

    protected String getLongName() {
        return this.getClass().getName();
    }

    protected OSGiRuntime getDefaultRuntime() {
        return this.getTestHelper().getDefaultRuntime();
    }

    protected OSGiRuntime getEmbeddedRuntime() {
        return this.getTestHelper().getEmbeddedRuntime();
    }

    public OSGiRuntime getRemoteRuntime() {
        return this.getTestHelper().getRemoteRuntime();
    }

    protected URL getResourceURL(String resource) {
        return this.getTestHelper().getResourceURL(resource);
    }

    protected File getResourceFile(String resource) {
        return this.getTestHelper().getResourceFile(resource);
    }

    protected URL getTestArchiveURL(String archive) {
        return this.getTestHelper().getTestArchiveURL(archive);
    }

    protected String getTestArchivePath(String archive) {
        return this.getTestHelper().getTestArchivePath(archive);
    }

    protected File getTestArchiveFile(String archive) {
        return this.getTestHelper().getTestArchiveFile(archive);
    }

    public InitialContext getInitialContext() throws NamingException {
        return this.getTestHelper().getInitialContext();
    }

    public Integer getJndiPort() {
        return this.getTestHelper().getJndiPort();
    }

    public String getServerHost() {
        return this.getTestHelper().getServerHost();
    }

    public String getTargetContainer() {
        return this.getTestHelper().getTargetContainer();
    }

    public String getFramework() {
        return this.getTestHelper().getFramework();
    }

    public boolean isFrameworkEquinox() {
        return this.getTestHelper().isFrameworkEquinox();
    }

    public boolean isFrameworkFelix() {
        return this.getTestHelper().isFrameworkFelix();
    }

    public boolean isFrameworkJBossMC() {
        return this.getTestHelper().isFrameworkJBossMC();
    }
}

