/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class BundleInfo
implements Serializable {
    private static final long serialVersionUID = -2363297020450715134L;
    private URL rootURL;
    private String location;
    private String symbolicName;
    private String bundleVersion;
    private transient VirtualFile rootFile;
    private transient Manifest manifest;

    public static BundleInfo createBundleInfo(String location) throws BundleException {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        URL url = BundleInfo.getRealLocation(location);
        if (url == null) {
            throw new IllegalArgumentException("Cannot obtain real location for: " + location);
        }
        return new BundleInfo(BundleInfo.toVirtualFile(url), url.toExternalForm());
    }

    public static BundleInfo createBundleInfo(URL url) throws BundleException {
        if (url == null) {
            throw new IllegalArgumentException("Null root url");
        }
        return new BundleInfo(BundleInfo.toVirtualFile(url), url.toExternalForm());
    }

    public static BundleInfo createBundleInfo(VirtualFile root) throws BundleException {
        return new BundleInfo(root, null);
    }

    public static BundleInfo createBundleInfo(VirtualFile root, String location) throws BundleException {
        return new BundleInfo(root, location);
    }

    private BundleInfo(VirtualFile rootFile, String location) throws BundleException {
        if (rootFile == null) {
            throw new IllegalArgumentException("Root file cannot be null");
        }
        this.rootFile = rootFile;
        this.rootURL = BundleInfo.toURL(rootFile);
        if (location == null) {
            location = this.rootURL.toExternalForm();
        }
        this.location = location;
        try {
            this.manifest = VFSUtils.getManifest((VirtualFile)rootFile);
            if (this.manifest == null) {
                throw new BundleException("Cannot get manifest from: " + this.rootURL);
            }
        }
        catch (IOException ex) {
            throw new BundleException("Cannot get manifest from: " + this.rootURL, (Throwable)ex);
        }
        BundleInfo.validateBundleManifest(this.manifest);
        int manifestVersion = BundleInfo.getBundleManifestVersion(this.manifest);
        this.symbolicName = this.getManifestHeader("Bundle-SymbolicName");
        this.bundleVersion = this.getManifestHeader("Bundle-Version");
        if (manifestVersion == 1) {
            this.symbolicName = "anonymous-bundle";
            try {
                this.bundleVersion = Version.parseVersion((String)this.bundleVersion).toString();
            }
            catch (NumberFormatException ex) {
                this.bundleVersion = Version.emptyVersion.toString();
            }
        }
    }

    public static boolean isValidBundle(VirtualFile virtualFile) {
        try {
            Manifest manifest = VFSUtils.getManifest((VirtualFile)virtualFile);
            return BundleInfo.isValidateBundleManifest(manifest);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isValidateBundleManifest(Manifest manifest) {
        if (manifest == null) {
            return false;
        }
        try {
            BundleInfo.validateBundleManifest(manifest);
            return true;
        }
        catch (BundleException e) {
            return false;
        }
    }

    public static void validateBundleManifest(Manifest manifest) throws BundleException {
        int manifestVersion = BundleInfo.getBundleManifestVersion(manifest);
        if (manifestVersion < 0) {
            throw new BundleException("Cannot determine Bundle-ManifestVersion");
        }
        if (manifestVersion > 2) {
            throw new BundleException("Unsupported Bundle-ManifestVersion: " + manifestVersion);
        }
        String symbolicName = BundleInfo.getManifestHeaderInternal(manifest, "Bundle-SymbolicName");
        String bundleVersion = BundleInfo.getManifestHeaderInternal(manifest, "Bundle-Version");
        if (manifestVersion == 1 && symbolicName != null) {
            throw new BundleException("Invalid Bundle-ManifestVersion:=1 for " + symbolicName);
        }
        if (manifestVersion == 2) {
            if (symbolicName == null) {
                throw new BundleException("Cannot obtain Bundle-SymbolicName");
            }
            Version.parseVersion((String)bundleVersion).toString();
        }
    }

    public static int getBundleManifestVersion(Manifest manifest) {
        if (manifest == null) {
            throw new IllegalArgumentException("Null manifest");
        }
        String bundleName = BundleInfo.getManifestHeaderInternal(manifest, "Bundle-Name");
        String bundleSymbolicName = BundleInfo.getManifestHeaderInternal(manifest, "Bundle-SymbolicName");
        String bundleVersion = BundleInfo.getManifestHeaderInternal(manifest, "Bundle-Version");
        if (bundleName == null && bundleSymbolicName == null && bundleVersion == null) {
            return -1;
        }
        String manifestVersion = BundleInfo.getManifestHeaderInternal(manifest, "Bundle-ManifestVersion");
        return manifestVersion != null ? Integer.parseInt(manifestVersion) : 1;
    }

    public String getManifestHeader(String key) {
        String value = BundleInfo.getManifestHeaderInternal(this.getManifest(), key);
        return value;
    }

    public String getLocation() {
        return this.location;
    }

    public VirtualFile getRoot() {
        if (this.rootFile == null) {
            this.rootFile = BundleInfo.toVirtualFile(this.rootURL);
        }
        return this.rootFile;
    }

    public URL getRootURL() {
        return BundleInfo.toURL(this.getRoot());
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return Version.parseVersion((String)this.bundleVersion);
    }

    public void close() {
        if (this.rootFile != null) {
            VFSUtils.safeClose((Closeable)this.rootFile);
        }
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                this.manifest = VFSUtils.getManifest((VirtualFile)this.getRoot());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot get manifest from: " + this.rootURL, ex);
            }
        }
        return this.manifest;
    }

    private static VirtualFile toVirtualFile(URL url) {
        try {
            return AbstractVFS.toVirtualFile((URL)url);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid root url: " + url, e);
        }
    }

    private static URL getRealLocation(String location) {
        String prefix;
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (url == null) {
            try {
                File file = new File(location);
                if (file.exists()) {
                    url = file.toURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (url == null && !location.startsWith(prefix = System.getProperty("test.archive.directory", "target/test-libs")) && new File(prefix).exists()) {
            return BundleInfo.getRealLocation(prefix + File.separator + location);
        }
        return url;
    }

    private static URL toURL(VirtualFile file) {
        try {
            return file.toURL();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid root file: " + file);
        }
    }

    private String toEqualString() {
        return "[" + this.symbolicName + ":" + this.bundleVersion + ",url=" + this.rootURL + "]";
    }

    private static String getManifestHeaderInternal(Manifest manifest, String key) {
        Attributes attribs = manifest.getMainAttributes();
        String value = attribs.getValue(key);
        return value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BundleInfo)) {
            return false;
        }
        BundleInfo other = (BundleInfo)obj;
        return this.toEqualString().equals(other.toEqualString());
    }

    public int hashCode() {
        return this.toEqualString().hashCode();
    }

    public String toString() {
        return this.toEqualString();
    }
}

