/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.capability.Capability;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.OSGiRuntime;
import org.jboss.osgi.testing.OSGiRuntimeHelper;
import org.jboss.osgi.testing.OSGiServiceReference;
import org.jboss.osgi.testing.OSGiTestHelper;
import org.jboss.osgi.testing.internal.ManagementSupport;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.PackageStateMBean;
import org.osgi.jmx.framework.ServiceStateMBean;

public abstract class OSGiRuntimeImpl
implements OSGiRuntime {
    private static final Logger log = Logger.getLogger(OSGiRuntimeImpl.class);
    private ManagementSupport jmxSupport;
    private OSGiRuntimeHelper helper;
    private Map<String, BundleTuple> bundles = new LinkedHashMap<String, BundleTuple>();
    private List<Capability> capabilities = new ArrayList<Capability>();

    public OSGiRuntimeImpl(OSGiRuntimeHelper helper) {
        this.helper = helper;
    }

    public OSGiRuntimeHelper getTestHelper() {
        return this.helper;
    }

    @Override
    public void addCapability(Capability capability) throws BundleException {
        for (Capability dependency : capability.getDependencies()) {
            this.addCapability(dependency);
        }
        OSGiServiceReference[] srefs = null;
        String serviceName = capability.getServiceName();
        if (serviceName != null) {
            srefs = this.getServiceReferences(serviceName, capability.getFilter());
        }
        if (srefs == null || srefs.length == 0) {
            log.debug((Object)("Add capability: " + capability));
            capability.install(this);
            capability.start(this);
            this.capabilities.add(capability);
        } else {
            log.debug((Object)("Skip capability: " + capability));
        }
    }

    @Override
    public void removeCapability(Capability capability) {
        if (this.capabilities.remove(capability)) {
            log.debug((Object)("Remove capability : " + capability));
            capability.stop(this);
            capability.uninstall(this);
        }
        ArrayList<Capability> dependencies = new ArrayList<Capability>(capability.getDependencies());
        Collections.reverse(dependencies);
        for (Capability dependency : dependencies) {
            this.removeCapability(dependency);
        }
    }

    @Override
    public OSGiBundle installBundle(String location) throws BundleException {
        BundleInfo info = BundleInfo.createBundleInfo(location);
        return this.installBundle(info);
    }

    @Override
    public OSGiBundle installBundle(Archive<?> archive) throws BundleException, IOException {
        VirtualFile virtualFile = OSGiTestHelper.toVirtualFile(archive);
        BundleInfo info = BundleInfo.createBundleInfo(virtualFile);
        return this.installBundle(info);
    }

    @Override
    public OSGiBundle installBundle(VirtualFile virtualFile) throws BundleException {
        BundleInfo info = BundleInfo.createBundleInfo(virtualFile);
        return this.installBundle(info);
    }

    private OSGiBundle installBundle(BundleInfo info) throws BundleException {
        log.debug((Object)("Install bundle: " + info));
        OSGiBundle bundle = this.installBundleInternal(info);
        this.bundles.put(info.getLocation(), new BundleTuple(info, bundle));
        return bundle;
    }

    abstract OSGiBundle installBundleInternal(BundleInfo var1) throws BundleException;

    @Override
    public void shutdown() {
        log.debug((Object)"Start Shutdown");
        ArrayList<String> locations = new ArrayList<String>(this.bundles.keySet());
        Collections.reverse(locations);
        while (locations.size() > 0) {
            String location = locations.remove(0);
            BundleTuple tuple = this.bundles.get(location);
            OSGiBundle bundle = tuple.bundle;
            try {
                bundle.uninstall();
            }
            catch (BundleException e) {
                log.error((Object)("Cannot unintall bundle: " + bundle));
            }
        }
        Collections.reverse(this.capabilities);
        while (this.capabilities.size() > 0) {
            Capability capability = this.capabilities.get(0);
            this.removeCapability(capability);
        }
        log.debug((Object)"End Shutdown");
    }

    @Override
    public <T> T getMBeanProxy(ObjectName name, Class<T> interf) {
        return this.getJMXSupport().getMBeanProxy(name, interf);
    }

    @Override
    public FrameworkMBean getFrameworkMBean() throws IOException {
        return this.getJMXSupport().getFrameworkMBean();
    }

    @Override
    public BundleStateMBean getBundleStateMBean() throws IOException {
        return this.getJMXSupport().getBundleStateMBean();
    }

    @Override
    public PackageStateMBean getPackageStateMBean() throws IOException {
        return this.getJMXSupport().getPackageStateMBean();
    }

    @Override
    public ServiceStateMBean getServiceStateMBean() throws IOException {
        return this.getJMXSupport().getServiceStateMBean();
    }

    private ManagementSupport getJMXSupport() {
        if (this.jmxSupport == null) {
            this.jmxSupport = new ManagementSupport(this.getMBeanServer());
        }
        return this.jmxSupport;
    }

    @Override
    public InitialContext getInitialContext() throws NamingException {
        return this.helper.getInitialContext();
    }

    @Override
    public String getServerHost() {
        return this.helper.getServerHost();
    }

    @Override
    public OSGiBundle getBundle(String symbolicName, Version version) {
        OSGiBundle bundle = this.getBundle(symbolicName, version, false);
        return bundle;
    }

    @Override
    public OSGiServiceReference getServiceReference(String clazz, long timeout) {
        int fraction = 200;
        timeout /= (long)fraction;
        OSGiServiceReference sref = this.getServiceReference(clazz);
        while (sref == null && 0L < timeout--) {
            try {
                Thread.sleep(fraction);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            sref = this.getServiceReference(clazz);
        }
        return sref;
    }

    private OSGiBundle getBundle(String symbolicName, Version version, boolean mustExist) {
        OSGiBundle bundle = null;
        List<OSGiBundle> bundles = Arrays.asList(this.getBundles());
        for (OSGiBundle aux : bundles) {
            if (!aux.getSymbolicName().equals(symbolicName) || version != null && !version.equals((Object)aux.getVersion())) continue;
            bundle = aux;
            break;
        }
        if (bundle == null && mustExist) {
            throw new IllegalStateException("Cannot obtain bundle: " + symbolicName + "-" + version + ". We have " + bundles);
        }
        return bundle;
    }

    void unregisterBundle(OSGiBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Cannot unregister null bundle");
        }
        String location = bundle.getLocation();
        BundleTuple tuple = this.bundles.remove(location);
        if (tuple != null) {
            tuple.close();
        }
    }

    class BundleTuple {
        BundleInfo info;
        OSGiBundle bundle;

        BundleTuple(BundleInfo info, OSGiBundle bundle) {
            this.info = info;
            this.bundle = bundle;
        }

        public void close() {
            this.info.close();
        }
    }
}

