/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.osgi.testing.OSGiTestHelper;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.osgi.framework.Bundle;

public abstract class OSGiTest {
    private static final Logger log = Logger.getLogger(OSGiTest.class);
    private OSGiTestHelper helper;

    protected OSGiTestHelper getTestHelper() {
        if (this.helper == null) {
            this.helper = new OSGiTestHelper();
        }
        return this.helper;
    }

    @Before
    public void setUp() throws Exception {
        log.debug((Object)("### START " + this.getLongName()));
    }

    @After
    public void tearDown() throws Exception {
        log.debug((Object)("### END " + this.getLongName()));
    }

    protected String getShortName() {
        String shortName = this.getClass().getName();
        shortName = shortName.substring(shortName.lastIndexOf(".") + 1);
        return shortName;
    }

    protected String getLongName() {
        return this.getClass().getName();
    }

    protected URL getResourceURL(String resource) {
        return this.getTestHelper().getResourceURL(resource);
    }

    protected File getResourceFile(String resource) {
        return this.getTestHelper().getResourceFile(resource);
    }

    protected URL getTestArchiveURL(String archive) {
        return this.getTestHelper().getTestArchiveURL(archive);
    }

    protected String getTestArchivePath(String archive) {
        return this.getTestHelper().getTestArchivePath(archive);
    }

    protected File getTestArchiveFile(String archive) {
        return this.getTestHelper().getTestArchiveFile(archive);
    }

    protected InitialContext getInitialContext() throws NamingException {
        return this.getTestHelper().getInitialContext();
    }

    protected String getServerHost() {
        return this.getTestHelper().getServerHost();
    }

    protected String getTargetContainer() {
        return this.getTestHelper().getTargetContainer();
    }

    protected String getFrameworkName() {
        return this.getTestHelper().getFrameworkName();
    }

    protected JavaArchive assembleArchive(String name, String resource, Class<?> ... packages) throws Exception {
        return this.getTestHelper().assembleArchive(name, resource, packages);
    }

    protected JavaArchive assembleArchive(String name, String[] resources, Class<?> ... packages) throws Exception {
        return this.getTestHelper().assembleArchive(name, resources, packages);
    }

    protected VirtualFile toVirtualFile(Archive<?> archive) throws IOException, MalformedURLException {
        return OSGiTestHelper.toVirtualFile(archive);
    }

    protected InputStream toInputStream(Archive<?> archive) throws IOException, MalformedURLException {
        return OSGiTestHelper.toInputStream(archive);
    }

    protected void assertBundleState(int expState, int wasState) {
        this.getTestHelper().assertBundleState(expState, wasState);
    }

    protected Class<?> assertLoadClass(Bundle bundle, String className) {
        return this.getTestHelper().assertLoadClass(bundle, className);
    }

    protected void assertLoadClassFail(Bundle bundle, String className) {
        this.getTestHelper().assertLoadClassFail(bundle, className);
    }

    protected void assertLoadClass(Bundle bundle, String className, Bundle exporter) {
        this.getTestHelper().assertLoadClass(bundle, className, exporter);
    }

    boolean isBeforeClassPresent() {
        boolean isPresent = false;
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(BeforeClass.class)) continue;
            isPresent = true;
            break;
        }
        return isPresent;
    }
}

