/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.osgi.jmx.BundleStateMBeanExt;
import org.jboss.osgi.jmx.FrameworkMBeanExt;
import org.jboss.osgi.jmx.ObjectNameFactory;
import org.jboss.osgi.jmx.PackageStateMBeanExt;
import org.jboss.osgi.jmx.ServiceStateMBeanExt;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.PackageStateMBean;
import org.osgi.jmx.framework.ServiceStateMBean;

public class ManagementSupport {
    private MBeanServerConnection mbeanServer;

    public ManagementSupport(MBeanServerConnection mbeanServer) {
        if (mbeanServer == null) {
            throw new IllegalArgumentException("Null mbeanServer");
        }
        this.mbeanServer = mbeanServer;
    }

    public <T> T getMBeanProxy(ObjectName name, Class<T> interf) {
        return MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, name, interf, false);
    }

    public MBeanServerConnection getMBeanServer() {
        return this.mbeanServer;
    }

    public FrameworkMBean getFrameworkMBean() throws IOException {
        FrameworkMBean frameworkState = null;
        ObjectName objectName = ObjectNameFactory.create((String)"jboss.osgi:service=jmx,type=Framework");
        if (this.mbeanServer.isRegistered(objectName)) {
            frameworkState = (FrameworkMBean)this.getMBeanProxy(objectName, FrameworkMBeanExt.class);
        } else {
            objectName = ObjectNameFactory.create((String)"osgi.core:type=framework,version=1.5");
            frameworkState = this.getMBeanProxy(objectName, FrameworkMBean.class);
        }
        return frameworkState;
    }

    public BundleStateMBean getBundleStateMBean() throws IOException {
        BundleStateMBean bundleState = null;
        ObjectName objectName = ObjectNameFactory.create((String)"jboss.osgi:service=jmx,type=BundleState");
        if (this.mbeanServer.isRegistered(objectName)) {
            bundleState = (BundleStateMBean)this.getMBeanProxy(objectName, BundleStateMBeanExt.class);
        } else {
            objectName = ObjectNameFactory.create((String)"osgi.core:type=bundleState,version=1.5");
            bundleState = this.getMBeanProxy(objectName, BundleStateMBean.class);
        }
        return bundleState;
    }

    public PackageStateMBean getPackageStateMBean() throws IOException {
        PackageStateMBean packageState = null;
        ObjectName objectName = ObjectNameFactory.create((String)"jboss.osgi:service=jmx,type=PackageState");
        if (this.mbeanServer.isRegistered(objectName)) {
            packageState = (PackageStateMBean)this.getMBeanProxy(objectName, PackageStateMBeanExt.class);
        } else {
            objectName = ObjectNameFactory.create((String)"osgi.core:type=packageState,version=1.5");
            packageState = this.getMBeanProxy(objectName, PackageStateMBean.class);
        }
        return packageState;
    }

    public ServiceStateMBean getServiceStateMBean() throws IOException {
        ServiceStateMBean serviceState = null;
        ObjectName objectName = ObjectNameFactory.create((String)"jboss.osgi:service=jmx,type=ServiceState");
        if (this.mbeanServer.isRegistered(objectName)) {
            serviceState = (ServiceStateMBean)this.getMBeanProxy(objectName, ServiceStateMBeanExt.class);
        } else {
            objectName = ObjectNameFactory.create((String)"osgi.core:type=serviceState,version=1.5");
            serviceState = this.getMBeanProxy(objectName, ServiceStateMBean.class);
        }
        return serviceState;
    }
}

