/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.logging.Logger;
import org.jboss.osgi.jmx.JMXServiceURLFactory;
import org.jboss.osgi.jmx.MBeanProxy;
import org.jboss.osgi.jmx.ObjectNameFactory;
import org.jboss.osgi.jmx.ServiceStateMBeanExt;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.OSGiRuntimeHelper;
import org.jboss.osgi.testing.OSGiServiceReference;
import org.jboss.osgi.testing.internal.MainDeployerClient;
import org.jboss.osgi.testing.internal.OSGiRuntimeImpl;
import org.jboss.osgi.testing.internal.RemoteBundle;
import org.jboss.osgi.testing.internal.RemoteServiceReference;
import org.osgi.framework.BundleException;

public class RemoteRuntime
extends OSGiRuntimeImpl {
    private static final Logger log = Logger.getLogger(RemoteRuntime.class);
    private JMXConnector jmxConnector;

    public RemoteRuntime(OSGiRuntimeHelper helper) {
        super(helper);
    }

    @Override
    public boolean isRemoteRuntime() {
        return true;
    }

    @Override
    OSGiBundle installBundleInternal(BundleInfo info) throws BundleException {
        try {
            String location = info.getLocation();
            String streamURL = info.getRoot().getStreamURL().toExternalForm();
            long bundleId = this.getFrameworkMBean().installBundleFromURL(location, streamURL);
            return new RemoteBundle(this, bundleId);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new BundleException("Cannot install: " + info, (Throwable)ex);
        }
    }

    public void deploy(String location) throws Exception {
        URL archiveURL = this.getTestHelper().getTestArchiveURL(location);
        MainDeployerClient deployer = new MainDeployerClient(this);
        deployer.deploy(archiveURL);
    }

    public void undeploy(String location) throws Exception {
        URL archiveURL = this.getTestHelper().getTestArchiveURL(location);
        MainDeployerClient deployer = new MainDeployerClient(this);
        deployer.undeploy(archiveURL);
    }

    @Override
    public OSGiBundle[] getBundles() {
        HashSet<RemoteBundle> bundles = new HashSet<RemoteBundle>();
        try {
            TabularData listBundles = this.getBundleStateMBean().listBundles();
            for (CompositeData bundleType : listBundles.values()) {
                Long bundleId = (Long)bundleType.get("Identifier");
                try {
                    bundles.add(new RemoteBundle(this, bundleId));
                }
                catch (IOException ex) {
                    log.warn((Object)("Cannot initialize remote bundle: [" + bundleId + "] - " + ex.getMessage()));
                }
            }
            OSGiBundle[] bundleArr = new OSGiBundle[bundles.size()];
            bundles.toArray(bundleArr);
            return bundleArr;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot obtain remote bundles", ex);
        }
    }

    @Override
    public OSGiBundle getBundle(long bundleId) {
        for (OSGiBundle bundle : this.getBundles()) {
            if (bundleId != bundle.getBundleId()) continue;
            return bundle;
        }
        return null;
    }

    @Override
    public OSGiServiceReference getServiceReference(String clazz) {
        TabularData propertiesData;
        CompositeData serviceData;
        try {
            ServiceStateMBeanExt serviceState = this.getServiceStateMBeanExt();
            serviceData = serviceState.getService(clazz);
            if (serviceData == null) {
                return null;
            }
            Long serviceId = (Long)serviceData.get("Identifier");
            propertiesData = serviceState.getProperties(serviceId.longValue());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return new RemoteServiceReference(serviceData, propertiesData);
    }

    @Override
    public OSGiServiceReference[] getServiceReferences(String clazz, String filter) {
        ArrayList<RemoteServiceReference> srefs;
        TabularData servicesData;
        try {
            ServiceStateMBeanExt serviceState = this.getServiceStateMBeanExt();
            servicesData = serviceState.getServices(clazz, filter);
            if (servicesData == null) {
                return null;
            }
            srefs = new ArrayList<RemoteServiceReference>();
            for (CompositeData serviceData : servicesData.values()) {
                Long serviceId = (Long)serviceData.get("Identifier");
                TabularData propertiesData = serviceState.getProperties(serviceId.longValue());
                srefs.add(new RemoteServiceReference(serviceData, propertiesData));
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return srefs.toArray(new OSGiServiceReference[servicesData.size()]);
    }

    private ServiceStateMBeanExt getServiceStateMBeanExt() {
        ObjectName objectName = ObjectNameFactory.create((String)"jboss.osgi:service=jmx,type=ServiceState");
        return (ServiceStateMBeanExt)MBeanProxy.get((MBeanServerConnection)this.getMBeanServer(), (ObjectName)objectName, ServiceStateMBeanExt.class);
    }

    @Override
    public MBeanServerConnection getMBeanServer() {
        try {
            JMXServiceURL serviceURL = JMXServiceURLFactory.getServiceURL((String)this.getServerHost(), null, null);
            this.jmxConnector = JMXConnectorFactory.connect(serviceURL, null);
            return this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain MBeanServerConnection");
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.jmxConnector != null) {
            try {
                this.jmxConnector.close();
            }
            catch (IOException ex) {
                log.warn((Object)"Cannot close JMXConnector", (Throwable)ex);
            }
        }
    }
}

