/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.logging.Logger;
import org.jboss.osgi.testing.ClipboardMBean;

public class ClipboardImpl
extends StandardMBean
implements ClipboardMBean {
    private static final Logger log = Logger.getLogger(ClipboardImpl.class);
    private List<String> messages = new ArrayList<String>();

    public ClipboardImpl() throws NotCompliantMBeanException {
        super(ClipboardMBean.class);
    }

    @Override
    public void addMessage(String message) {
        log.info((Object)("addMessage: " + message));
        this.messages.add(message);
    }

    @Override
    public List<String> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    @Override
    public int getMessageCount() {
        return this.messages.size();
    }

    @Override
    public String getMessage(int index) {
        return this.messages.get(index);
    }

    @Override
    public String getLastMessage() {
        int count = this.getMessageCount();
        return count > 0 ? this.messages.get(count - 1) : null;
    }

    @Override
    public String removeMessage(int index) {
        String message = this.messages.get(index);
        log.info((Object)("removeMessage: " + message));
        return message;
    }

    @Override
    public void clearMessages() {
        log.info((Object)"clearMessages");
        this.messages.clear();
    }
}

