/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.util;

import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.osgi.spi.util.BundleDeployment;
import org.osgi.framework.BundleException;

public abstract class BundleDeploymentFactory {
    public static BundleDeployment createBundleDeployment(URL url) throws BundleException {
        Manifest manifest;
        try {
            JarFile jarFile = new JarFile(url.getPath());
            manifest = jarFile.getManifest();
            jarFile.close();
        }
        catch (IOException ex) {
            throw new BundleException("Cannot get manifest from: " + url);
        }
        Attributes attribs = manifest.getMainAttributes();
        String symbolicName = attribs.getValue("Bundle-SymbolicName");
        if (symbolicName == null) {
            throw new BundleException("Cannot obtain Bundle-SymbolicName for: " + url);
        }
        String version = attribs.getValue("Bundle-Version");
        return new BundleDeployment(url, symbolicName, version);
    }
}

