/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.testing.internal;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.management.MBeanProxy;
import org.jboss.osgi.spi.management.MBeanProxyException;
import org.jboss.osgi.spi.management.ManagedBundleMBean;
import org.jboss.osgi.spi.management.ManagedFrameworkMBean;
import org.jboss.osgi.spi.management.ManagedServiceReference;
import org.jboss.osgi.spi.testing.OSGiBundle;
import org.jboss.osgi.spi.testing.OSGiPackageAdmin;
import org.jboss.osgi.spi.testing.OSGiServiceReference;
import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.jboss.osgi.spi.testing.internal.OSGiRuntimeImpl;
import org.jboss.osgi.spi.testing.internal.RemoteBundle;
import org.jboss.osgi.spi.testing.internal.RemoteFramework;
import org.jboss.osgi.spi.testing.internal.RemoteFrameworkException;
import org.jboss.osgi.spi.testing.internal.RemotePackageAdmin;
import org.jboss.osgi.spi.testing.internal.RemoteServiceReference;
import org.jboss.osgi.spi.util.BundleDeployment;
import org.jboss.osgi.spi.util.BundleDeploymentFactory;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

public class RemoteRuntime
extends OSGiRuntimeImpl {
    private MBeanServerConnection mbeanServer;
    private ManagedFrameworkMBean managedFramework;

    public RemoteRuntime(OSGiTestHelper helper) {
        super(helper);
    }

    public OSGiBundle installBundle(String location) throws BundleException {
        try {
            URL bundleURL = this.getTestHelper().getTestArchiveURL(location);
            BundleDeployment bundleDep = BundleDeploymentFactory.createBundleDeployment(bundleURL);
            this.deployInternal(location, true);
            String symbolicName = bundleDep.getSymbolicName();
            String version = bundleDep.getVersion().toString();
            ManagedBundleMBean bundleMBean = this.getRemoteFramework().getBundle(symbolicName, version);
            RemoteBundle bundle = new RemoteBundle(this, bundleMBean, location);
            return this.registerBundle(location, bundle);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (MBeanException ex) {
            Exception target = ex.getTargetException();
            if (target instanceof BundleException) {
                throw (BundleException)((Object)target);
            }
            throw new BundleException("Cannot install: " + location, (Throwable)target);
        }
        catch (Exception ex) {
            throw new BundleException("Cannot install: " + location, (Throwable)ex);
        }
    }

    public void deploy(String location) throws Exception {
        this.deployInternal(location, false);
    }

    private void deployInternal(String location, boolean isBundle) throws Exception {
        URL archiveURL = this.getTestHelper().getTestArchiveURL(location);
        if (isBundle) {
            this.invokeDeployerService("deploy", archiveURL);
        } else {
            this.invokeMainDeployer("deploy", archiveURL);
        }
    }

    public void undeploy(String location) throws Exception {
        URL archiveURL = this.getTestHelper().getTestArchiveURL(location);
        if (this.isBundleArchive(location)) {
            this.invokeDeployerService("undeploy", archiveURL);
        } else {
            this.invokeMainDeployer("undeploy", archiveURL);
        }
    }

    private boolean isBundleArchive(String location) {
        try {
            URL archiveURL = this.getTestHelper().getTestArchiveURL(location);
            BundleDeploymentFactory.createBundleDeployment(archiveURL);
            return true;
        }
        catch (BundleException ex) {
            return false;
        }
    }

    public OSGiBundle[] getBundles() {
        try {
            Set<ManagedBundleMBean> remoteBundles = this.getRemoteFramework().getBundles();
            HashSet<RemoteBundle> bundles = new HashSet<RemoteBundle>();
            for (ManagedBundleMBean remoteBundle : remoteBundles) {
                bundles.add(new RemoteBundle(this, remoteBundle, null));
            }
            OSGiBundle[] bundleArr = new OSGiBundle[bundles.size()];
            bundles.toArray(bundleArr);
            return bundleArr;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot obtain remote bundles", ex);
        }
    }

    public OSGiBundle getBundle(long bundleId) {
        ManagedBundleMBean bundle = this.getRemoteFramework().getBundle(bundleId);
        return bundle != null ? new RemoteBundle(this, bundle, null) : null;
    }

    public OSGiServiceReference getServiceReference(String clazz) {
        ManagedServiceReference manref = this.getRemoteFramework().getServiceReference(clazz);
        return manref != null ? new RemoteServiceReference(manref) : null;
    }

    public OSGiServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        OSGiServiceReference[] srefs = null;
        ManagedServiceReference[] manrefs = this.getRemoteFramework().getServiceReferences(clazz, filter);
        if (manrefs != null) {
            srefs = new OSGiServiceReference[manrefs.length];
            for (int i = 0; i < manrefs.length; ++i) {
                srefs[i] = new RemoteServiceReference(manrefs[i]);
            }
        }
        return srefs;
    }

    public MBeanServerConnection getMBeanServer() {
        if (this.mbeanServer == null) {
            try {
                InitialContext iniCtx = this.getInitialContext();
                this.mbeanServer = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException ex) {
                throw new IllegalStateException("Cannot obtain MBeanServerConnection", ex);
            }
        }
        return this.mbeanServer;
    }

    public OSGiPackageAdmin getPackageAdmin() {
        return new RemotePackageAdmin(this);
    }

    public void shutdown() {
        OSGiBootstrapProvider bootProvider = this.getTestHelper().getBootstrapProvider();
        if (bootProvider != null) {
            super.shutdown();
            this.getPackageAdmin().refreshPackages(null);
        }
    }

    private RemoteFramework getRemoteFramework() {
        try {
            if (this.managedFramework == null) {
                this.managedFramework = MBeanProxy.get(ManagedFrameworkMBean.class, ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK, this.getMBeanServer());
            }
        }
        catch (MBeanProxyException ex) {
            throw new RemoteFrameworkException(ex);
        }
        return new RemoteFramework(){

            @Override
            public ManagedBundleMBean getBundle(String symbolicName, String version) {
                ObjectName oname = RemoteRuntime.this.managedFramework.getBundle(symbolicName, version);
                if (oname == null) {
                    throw new IllegalArgumentException("Cannot get remote bundle for: " + symbolicName);
                }
                try {
                    return MBeanProxy.get(ManagedBundleMBean.class, oname, RemoteRuntime.this.getMBeanServer());
                }
                catch (MBeanProxyException ex) {
                    throw new RemoteFrameworkException(ex);
                }
            }

            @Override
            public ManagedBundleMBean getBundle(long bundleId) {
                ObjectName oname = RemoteRuntime.this.managedFramework.getBundle(bundleId);
                if (oname == null) {
                    throw new IllegalArgumentException("Cannot get remote bundle for: " + bundleId);
                }
                try {
                    return MBeanProxy.get(ManagedBundleMBean.class, oname, RemoteRuntime.this.getMBeanServer());
                }
                catch (MBeanProxyException ex) {
                    throw new RemoteFrameworkException(ex);
                }
            }

            @Override
            public Set<ManagedBundleMBean> getBundles() {
                HashSet<ManagedBundleMBean> remBundles = new HashSet<ManagedBundleMBean>();
                for (ObjectName bundleOName : RemoteRuntime.this.managedFramework.getBundles()) {
                    try {
                        ManagedBundleMBean remBundle = MBeanProxy.get(ManagedBundleMBean.class, bundleOName, RemoteRuntime.this.getMBeanServer());
                        remBundles.add(remBundle);
                    }
                    catch (MBeanProxyException ex) {
                        throw new RemoteFrameworkException(ex);
                    }
                }
                return remBundles;
            }

            @Override
            public ManagedServiceReference getServiceReference(String clazz) {
                return RemoteRuntime.this.managedFramework.getServiceReference(clazz);
            }

            @Override
            public ManagedServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
                return RemoteRuntime.this.managedFramework.getServiceReferences(clazz, filter);
            }
        };
    }

    private void invokeMainDeployer(String method, URL archiveURL) throws Exception {
        ObjectName oname = new ObjectName("jboss.system:service=MainDeployer");
        this.getMBeanServer().invoke(oname, method, new Object[]{archiveURL}, new String[]{URL.class.getName()});
    }
}

