/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.framework;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.FrameworkException;
import org.jboss.osgi.spi.logging.ExportedPackageHelper;
import org.jboss.osgi.spi.util.ServiceLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkIntegration {
    final Logger log = Logger.getLogger(FrameworkIntegration.class);
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected List<URL> autoInstall = new ArrayList<URL>();
    protected List<URL> autoStart = new ArrayList<URL>();
    protected Framework framework;

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> props) {
        this.properties = props;
    }

    public List<URL> getAutoInstall() {
        return this.autoInstall;
    }

    public void setAutoInstall(List<URL> autoInstall) {
        this.autoInstall = autoInstall;
    }

    public List<URL> getAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(List<URL> autoStart) {
        this.autoStart = autoStart;
    }

    public Bundle getBundle() {
        this.assertFrameworkStart();
        return this.framework;
    }

    public BundleContext getBundleContext() {
        return this.getBundle().getBundleContext();
    }

    public void create() {
        FrameworkFactory factory = ServiceLoader.loadService(FrameworkFactory.class);
        this.framework = factory.newFramework(this.properties);
    }

    public void start() {
        Bundle bundle;
        this.assertFrameworkCreate();
        try {
            this.framework.start();
        }
        catch (BundleException ex) {
            throw new FrameworkException("Cannot start system bundle", ex);
        }
        BundleContext context = this.framework.getBundleContext();
        if (context == null) {
            throw new FrameworkException("Cannot obtain system context");
        }
        ExportedPackageHelper packageHelper = new ExportedPackageHelper(context);
        packageHelper.logExportedPackages(this.getBundle());
        HashMap<URL, Bundle> autoBundles = new HashMap<URL, Bundle>();
        for (URL bundleURL : this.autoStart) {
            this.autoInstall.add(bundleURL);
        }
        for (URL bundleURL : this.autoInstall) {
            try {
                bundle = context.installBundle(bundleURL.toString());
                long bundleId = bundle.getBundleId();
                this.log.info((Object)("Installed bundle [" + bundleId + "]: " + bundle.getSymbolicName()));
                autoBundles.put(bundleURL, bundle);
            }
            catch (BundleException ex) {
                this.stop();
                throw new IllegalStateException("Cannot install bundle: " + bundleURL, ex);
            }
        }
        for (URL bundleURL : this.autoStart) {
            try {
                bundle = (Bundle)autoBundles.get(bundleURL);
                if (bundle == null) continue;
                bundle.start();
                packageHelper.logExportedPackages(bundle);
                this.log.info((Object)("Started bundle: " + bundle.getSymbolicName()));
            }
            catch (BundleException ex) {
                this.stop();
                throw new IllegalStateException("Cannot start bundle: " + bundleURL, ex);
            }
        }
    }

    public void stop() {
        if (this.framework != null) {
            try {
                this.framework.stop();
                this.framework.waitForStop(5000L);
                this.framework = null;
                this.log.debug((Object)"SystemBundle STOPPED");
            }
            catch (BundleException ex) {
                this.log.error((Object)"Cannot stop Framework", (Throwable)ex);
            }
            catch (InterruptedException ex) {
                this.log.error((Object)"Cannot stop Framework", (Throwable)ex);
            }
        }
    }

    private void assertFrameworkCreate() {
        if (this.framework == null) {
            this.create();
        }
    }

    private void assertFrameworkStart() {
        this.assertFrameworkCreate();
        if ((this.framework.getState() & 0x20) == 0) {
            this.start();
        }
    }
}

