/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.testing.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import org.jboss.osgi.spi.capability.Capability;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.framework.OSGiFramework;
import org.jboss.osgi.spi.logging.LogEntryCache;
import org.jboss.osgi.spi.service.DeployerService;
import org.jboss.osgi.spi.testing.OSGiBundle;
import org.jboss.osgi.spi.testing.OSGiPackageAdmin;
import org.jboss.osgi.spi.testing.OSGiServiceReference;
import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.jboss.osgi.spi.testing.internal.EmbeddedBundle;
import org.jboss.osgi.spi.testing.internal.EmbeddedPackageAdmin;
import org.jboss.osgi.spi.testing.internal.EmbeddedServiceReference;
import org.jboss.osgi.spi.testing.internal.OSGiRuntimeImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class EmbeddedRuntime
extends OSGiRuntimeImpl {
    public EmbeddedRuntime(OSGiTestHelper helper) {
        super(helper);
    }

    public OSGiBundle installBundle(String location) throws BundleException {
        String symbolicName = this.getSymbolicName(location);
        URL bundleURL = this.getTestHelper().getTestArchiveURL(location);
        ServiceReference sref = this.getBundleContext().getServiceReference(DeployerService.class.getName());
        DeployerService service = (DeployerService)this.getBundleContext().getService(sref);
        service.deploy(bundleURL);
        OSGiBundle bundle = this.getBundle(symbolicName, null);
        return bundle;
    }

    public OSGiBundle[] getBundles() {
        ArrayList<EmbeddedBundle> absBundles = new ArrayList<EmbeddedBundle>();
        for (Bundle bundle : this.getBundleContext().getBundles()) {
            absBundles.add(new EmbeddedBundle(bundle));
        }
        OSGiBundle[] bundleArr = new OSGiBundle[absBundles.size()];
        absBundles.toArray(bundleArr);
        return bundleArr;
    }

    public OSGiServiceReference getServiceReference(String clazz) {
        ServiceReference sref = this.getBundleContext().getServiceReference(clazz);
        return sref != null ? new EmbeddedServiceReference(sref) : null;
    }

    public OSGiServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        OSGiServiceReference[] retRefs = null;
        ServiceReference[] srefs = this.getBundleContext().getServiceReferences(clazz, filter);
        if (srefs != null) {
            retRefs = new OSGiServiceReference[srefs.length];
            for (int i = 0; i < srefs.length; ++i) {
                retRefs[i] = new EmbeddedServiceReference(srefs[i]);
            }
        }
        return retRefs;
    }

    public void addCapability(Capability capability) throws BundleException {
        Properties props = capability.getProperties();
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            String value = props.getProperty(key);
            System.setProperty(key, value);
        }
        super.addCapability(capability);
    }

    public void startLogEntryTracking(final LogEntryCache logEntryCache) {
        super.startLogEntryTracking(logEntryCache);
        ServiceTracker tracker = new ServiceTracker(this.getBundleContext(), LogReaderService.class.getName(), null){

            public Object addingService(ServiceReference sref) {
                LogReaderService logReaderService = (LogReaderService)super.addingService(sref);
                logReaderService.addLogListener((LogListener)logEntryCache);
                EmbeddedRuntime.this.setLogReaderService(logReaderService);
                return logReaderService;
            }
        };
        tracker.open();
    }

    public void shutdown() {
        super.shutdown();
        OSGiBootstrapProvider bootProvider = this.getTestHelper().getBootstrapProvider();
        bootProvider.getFramework().stop();
    }

    public BundleContext getBundleContext() {
        OSGiBootstrapProvider bootProvider = this.getTestHelper().getBootstrapProvider();
        OSGiFramework framework = bootProvider.getFramework();
        return framework.getBundleContext();
    }

    public MBeanServerConnection getMBeanServer() {
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            throw new IllegalStateException("Multiple MBeanServer instances not supported");
        }
        MBeanServer server = null;
        if (serverArr.size() == 1) {
            server = serverArr.get(0);
        }
        if (server == null) {
            server = MBeanServerFactory.createMBeanServer();
        }
        return server;
    }

    public OSGiPackageAdmin getPackageAdmin() {
        BundleContext context = this.getBundleContext();
        ServiceReference sref = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packAdmin = (PackageAdmin)context.getService(sref);
        return new EmbeddedPackageAdmin(packAdmin);
    }
}

