/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.management;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.management.ManagedFrameworkMBean;
import org.jboss.osgi.spi.management.ManagedServiceReference;
import org.jboss.osgi.spi.management.ObjectNameFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedFramework
implements ManagedFrameworkMBean {
    final Logger log = Logger.getLogger(ManagedFramework.class);
    private MBeanServer mbeanServer;
    private BundleContext systemContext;

    public ManagedFramework(BundleContext systemContext, MBeanServer mbeanServer) {
        this.systemContext = systemContext;
        this.mbeanServer = mbeanServer;
    }

    public ManagedFramework() {
    }

    public void setMbeanServer(MBeanServer server) {
        this.mbeanServer = server;
    }

    public void setSystemContext(BundleContext systemContext) {
        this.systemContext = systemContext;
    }

    @Override
    public ObjectName getBundle(String symbolicName) {
        ObjectName pattern = ObjectNameFactory.create("jboss.osgi:bundle=" + symbolicName + ",*");
        Set<ObjectName> names = this.mbeanServer.queryNames(pattern, null);
        if (names.size() < 1) {
            return null;
        }
        if (names.size() > 1) {
            throw new IllegalArgumentException("Multiple bundles found: " + names);
        }
        return names.iterator().next();
    }

    @Override
    public Set<ObjectName> getBundles() {
        ObjectName pattern = ObjectNameFactory.create("jboss.osgi:*");
        Set<ObjectName> names = this.mbeanServer.queryNames(pattern, new IsBundleQueryExp());
        return names;
    }

    @Override
    public ManagedServiceReference getServiceReference(String clazz) {
        ManagedServiceReference manref = null;
        ServiceReference sref = this.systemContext.getServiceReference(clazz);
        if (sref != null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String key : sref.getPropertyKeys()) {
                props.put(key, sref.getProperty(key));
            }
            manref = new ManagedServiceReference(props);
        }
        return manref;
    }

    @Override
    public ManagedServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        ArrayList<ManagedServiceReference> foundRefs = new ArrayList<ManagedServiceReference>();
        ServiceReference[] srefs = this.systemContext.getServiceReferences(clazz, filter);
        if (srefs != null) {
            for (ServiceReference sref : srefs) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                for (String key : sref.getPropertyKeys()) {
                    props.put(key, sref.getProperty(key));
                }
                foundRefs.add(new ManagedServiceReference(props));
            }
        }
        ManagedServiceReference[] manrefs = null;
        if (foundRefs.size() > 0) {
            manrefs = foundRefs.toArray(new ManagedServiceReference[foundRefs.size()]);
        }
        return manrefs;
    }

    @Override
    public void refreshPackages(String[] symbolicNames) {
        ServiceReference sref = this.systemContext.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin service = (PackageAdmin)this.systemContext.getService(sref);
        Bundle[] bundles = null;
        if (symbolicNames != null) {
            List<String> nameList = Arrays.asList(symbolicNames);
            HashSet<Bundle> bundleSet = new HashSet<Bundle>();
            for (Bundle bundle : this.systemContext.getBundles()) {
                if (!nameList.contains(bundle.getSymbolicName())) continue;
                bundleSet.add(bundle);
            }
            bundles = new Bundle[bundleSet.size()];
            bundleSet.toArray(bundles);
        }
        service.refreshPackages(bundles);
    }

    public void start() {
        try {
            if (this.mbeanServer != null) {
                this.mbeanServer.registerMBean(this, ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK);
            }
        }
        catch (JMException ex) {
            this.log.warn((Object)("Cannot register: " + ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK));
        }
    }

    public void stop() {
        try {
            if (this.mbeanServer != null && this.mbeanServer.isRegistered(MBEAN_MANAGED_FRAMEWORK)) {
                this.mbeanServer.unregisterMBean(ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK);
            }
        }
        catch (JMException ex) {
            this.log.warn((Object)("Cannot register: " + ManagedFrameworkMBean.MBEAN_MANAGED_FRAMEWORK));
        }
    }

    static class IsBundleQueryExp
    implements QueryExp {
        private static final long serialVersionUID = 1L;

        IsBundleQueryExp() {
        }

        public boolean apply(ObjectName name) {
            return name.getKeyProperty("bundle") != null;
        }

        public void setMBeanServer(MBeanServer server) {
        }
    }
}

