/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.logging;

import java.util.ArrayList;
import java.util.List;
import org.jboss.osgi.spi.logging.LogEntryFilter;
import org.jboss.osgi.spi.logging.internal.LogEntryImpl;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogEntryCache
implements LogListener {
    private List<LogEntry> entries = new ArrayList<LogEntry>();
    private List<LogEntryFilter> filters = new ArrayList<LogEntryFilter>();

    public LogEntryCache(LogEntryFilter filter) {
        this.filters.add(filter);
    }

    public LogEntryCache() {
    }

    public void addFilter(LogEntryFilter filter) {
        this.filters.add(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<LogEntry> list = this.entries;
        synchronized (list) {
            this.entries.clear();
        }
    }

    public void clearFilters() {
        this.filters = new ArrayList<LogEntryFilter>();
    }

    public List<LogEntry> getLog() {
        return this.getLog(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> getLog(boolean clear) {
        List<LogEntry> list = this.entries;
        synchronized (list) {
            ArrayList<LogEntry> retList = new ArrayList<LogEntry>(this.entries);
            if (clear) {
                this.entries.clear();
            }
            return retList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logged(LogEntry entry) {
        entry = new LogEntryImpl(entry);
        ArrayList<LogEntryFilter> snapshot = new ArrayList<LogEntryFilter>(this.filters);
        List<LogEntry> list = this.entries;
        synchronized (list) {
            if (snapshot.size() == 0) {
                this.entries.add(entry);
                return;
            }
            for (LogEntryFilter filter : snapshot) {
                if (!this.match(filter, entry)) continue;
                this.entries.add(entry);
                break;
            }
        }
    }

    private boolean match(LogEntryFilter filter, LogEntry entry) {
        String filterRegex;
        boolean match;
        boolean bl = match = entry.getLevel() <= filter.getLevel();
        if (match && filter.getBundleRegex() != null) {
            String entryBnd = entry.getBundle().getSymbolicName();
            filterRegex = filter.getBundleRegex();
            match = entryBnd.matches(filterRegex);
        }
        if (match && filter.getMessageRegex() != null) {
            String entryMsg = entry.getMessage();
            filterRegex = filter.getMessageRegex();
            match = entryMsg.matches(filterRegex);
        }
        return match;
    }
}

