/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.osgi.spi.NotImplementedException;
import org.jboss.osgi.spi.framework.OSGiBootstrapProvider;
import org.jboss.osgi.spi.framework.OSGiFramework;
import org.jboss.osgi.spi.internal.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBootstrapProvider
implements OSGiBootstrapProvider {
    public static final String OSGI_FRAMEWORK_CONFIG = "jboss.osgi.framework.properties";
    public static final String DEFAULT_OSGI_FRAMEWORK_PROPERTIES = "jboss-osgi-framework.properties";
    public static final String PROP_OSGI_FRAMEWORK_IMPL = "org.jboss.osgi.spi.framework.impl";
    public static final String PROP_OSGI_FRAMEWORK_AUTO_INSTALL = "org.jboss.osgi.spi.framework.autoInstall";
    public static final String PROP_OSGI_FRAMEWORK_AUTO_START = "org.jboss.osgi.spi.framework.autoStart";
    private static Set<String> internalProps = new HashSet<String>();
    private OSGiFramework framework;
    private boolean configured;

    @Override
    public void configure() {
        throw new NotImplementedException();
    }

    @Override
    public void configure(URL urlConfig) {
        Properties props = this.getBootstrapProperties(urlConfig);
        this.framework = this.loadFrameworkImpl(urlConfig, props);
        this.initFrameworkProperties(props);
        List<URL> installURLs = this.getBundleURLs(props, PROP_OSGI_FRAMEWORK_AUTO_INSTALL);
        this.framework.setAutoInstall(installURLs);
        List<URL> startURLs = this.getBundleURLs(props, PROP_OSGI_FRAMEWORK_AUTO_START);
        this.framework.setAutoStart(startURLs);
        this.configured = true;
    }

    private List<URL> getBundleURLs(Properties props, String key) {
        String bundleList = props.getProperty(key);
        if (bundleList == null) {
            bundleList = "";
        }
        ArrayList<URL> bundleURLs = new ArrayList<URL>();
        for (String bundle : bundleList.split("[, ]")) {
            if (bundle.trim().length() <= 0) continue;
            URL installURL = this.toURL(bundle);
            bundleURLs.add(installURL);
        }
        return bundleURLs;
    }

    private URL toURL(String path) {
        String realPath = StringPropertyReplacer.replaceProperties(path);
        try {
            URL pathURL = new URL(realPath);
            return pathURL;
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Invalid path: " + path, ex);
        }
    }

    @Override
    public void configure(String resourceConfig) {
        URL urlConfig = Thread.currentThread().getContextClassLoader().getResource(resourceConfig);
        if (urlConfig == null) {
            throw new IllegalStateException("Cannot find resource: " + resourceConfig);
        }
        this.configure(urlConfig);
    }

    @Override
    public void configure(InputStream streamConfig) {
        throw new NotImplementedException();
    }

    @Override
    public OSGiFramework getFramework() {
        if (!this.configured) {
            String defaultFrameworkProps = System.getProperty(OSGI_FRAMEWORK_CONFIG, DEFAULT_OSGI_FRAMEWORK_PROPERTIES);
            this.configure(defaultFrameworkProps);
        }
        return this.framework;
    }

    @Override
    public OSGiFramework getFramework(String name) {
        throw new NotImplementedException();
    }

    @Override
    public Object getInstance(String name) {
        throw new NotImplementedException();
    }

    @Override
    public <T> T getInstance(String name, Class<T> expectedType) {
        throw new NotImplementedException();
    }

    private void initFrameworkProperties(Properties props) {
        HashMap<String, Object> frameworkProps = new HashMap<String, Object>();
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (internalProps.contains(key)) continue;
            String value = props.getProperty(key);
            frameworkProps.put(key, value);
        }
        this.framework.setProperties(frameworkProps);
    }

    private OSGiFramework loadFrameworkImpl(URL urlConfig, Properties props) {
        OSGiFramework framework;
        String frameworkImpl = props.getProperty(PROP_OSGI_FRAMEWORK_IMPL);
        if (frameworkImpl == null) {
            throw new IllegalStateException("Cannot get : " + urlConfig);
        }
        try {
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            Class<?> frameworkClass = ctxLoader.loadClass(frameworkImpl);
            framework = (OSGiFramework)frameworkClass.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot load framework: " + frameworkImpl, ex);
        }
        return framework;
    }

    private Properties getBootstrapProperties(URL urlConfig) {
        Properties props = new Properties();
        try {
            InputStream inStream = urlConfig.openStream();
            props.load(inStream);
            inStream.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot load properties from: " + urlConfig, ex);
        }
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            props.setProperty(key, StringPropertyReplacer.replaceProperties(value));
        }
        return props;
    }

    static {
        internalProps.add(PROP_OSGI_FRAMEWORK_IMPL);
        internalProps.add(PROP_OSGI_FRAMEWORK_AUTO_INSTALL);
        internalProps.add(PROP_OSGI_FRAMEWORK_AUTO_START);
    }
}

