/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.spi.testing.internal;

import java.util.Dictionary;

import org.jboss.logging.Logger;
import org.jboss.osgi.spi.management.ManagedBundleMBean;
import org.jboss.osgi.spi.testing.OSGiBundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Constants;

/**
 * An implementation of a remote {@link OSGiBundle}
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 25-Sep-2008
 */
public class RemoteBundle extends OSGiBundle
{
   // Provide logging
   private static final Logger log = Logger.getLogger(RemoteBundle.class);
   
   private OSGiRuntimeImpl runtime;
   private ManagedBundleMBean bundle;
   private String location;

   public RemoteBundle(OSGiRuntimeImpl runtime, ManagedBundleMBean bundle, String location)
   {
      this.runtime = runtime;
      this.bundle = bundle;
      this.location = location;
   }

   @Override
   public int getState()
   {
      return bundle.getState();
   }

   @Override
   public String getSymbolicName()
   {
      return bundle.getSymbolicName();
   }

   @Override
   public String getVersion()
   {
      return getHeaders().get(Constants.BUNDLE_VERSION);
   }

   @Override
   public Dictionary<String, String> getHeaders()
   {
      return bundle.getHeaders();
   }

   @Override
   public long getBundleId()
   {
      return bundle.getBundleId();
   }

   @Override
   public String getProperty(String key)
   {
      return bundle.getProperty(key);
   }

   @Override
   public void start() throws BundleException
   {
      bundle.start();
   }

   @Override
   public void stop() throws BundleException
   {
      bundle.stop();
   }

   @Override
   public void uninstall() throws BundleException
   {
      try
      {
         runtime.undeploy(location);
      }
      catch (RuntimeException rte)
      {
         throw rte;
      }
      catch (Exception ex)
      {
         log.error("Cannot uninstall: " + location);
      }
   }
}
