/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.junit;

import java.net.URL;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.osgi.spi.junit.ArchiveDeployer;
import org.jboss.osgi.spi.junit.JBossArchiveDeployer;
import org.jboss.osgi.spi.junit.OSGiTestHelper;

public class IntegrationTestHelper
extends OSGiTestHelper {
    private static MBeanServerConnection server;
    private String integrationTarget;

    public void deploy(String archive) throws Exception {
        URL url = this.getTestArchiveFile(archive).toURI().toURL();
        this.deploy(url);
    }

    public void deploy(URL archive) throws Exception {
        this.getDeployer().deploy(archive);
    }

    public void undeploy(String archive) throws Exception {
        URL url = this.getTestArchiveFile(archive).toURI().toURL();
        this.undeploy(url);
    }

    public void undeploy(URL archive) throws Exception {
        this.getDeployer().undeploy(archive);
    }

    public boolean isTargetJBoss50() {
        String target = this.getIntegrationTarget();
        return target.startsWith("jboss50");
    }

    private String getIntegrationTarget() {
        if (this.integrationTarget == null) {
            String jbossVersion;
            try {
                ObjectName oname = new ObjectName("jboss.system:type=ServerConfig");
                jbossVersion = (String)this.getServer().getAttribute(oname, "SpecificationVersion");
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot obtain jboss version", ex);
            }
            if (jbossVersion.startsWith("5.0")) {
                this.integrationTarget = "jboss50";
            } else {
                throw new IllegalStateException("Unsupported jboss version: " + jbossVersion);
            }
        }
        return this.integrationTarget;
    }

    public MBeanServerConnection getServer() {
        if (server == null) {
            Hashtable<?, ?> jndiEnv = null;
            try {
                InitialContext iniCtx = new InitialContext();
                jndiEnv = iniCtx.getEnvironment();
                server = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException ex) {
                throw new RuntimeException("Cannot obtain MBeanServerConnection using jndi props: " + jndiEnv, ex);
            }
        }
        return server;
    }

    private ArchiveDeployer getDeployer() {
        return new JBossArchiveDeployer(this.getServer());
    }

    public String getServerHost() {
        return System.getProperty("jboss.bind.address", "localhost");
    }
}

